/***********************************************************************
 * Id: LPC43xx_TC2.h
 *
 * Project: LPC43xx Common
 *
 * Description: CMSIS Cortex-M4 Core Peripheral Access Layer Header File
 *              for NXP LPC43xx Device Series
 *
 ***********************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 **********************************************************************/
#ifndef __LPC43xx_TC2_H__
#define __LPC43xx_TC2_H__

/*
 * ==========================================================================
 * ---------- Interrupt Number Definition -----------------------------------
 * ==========================================================================
 */

typedef enum IRQn
{
/******  Cortex-M4 Processor Exceptions Numbers ***************************************************/
    NonMaskableInt_IRQn     = -14,          /*!< 2 Non Maskable Interrupt                         */
    MemoryManagement_IRQn   = -12,          /*!< 4 Cortex-M4 Memory Management Interrupt          */
    BusFault_IRQn           = -11,          /*!< 5 Cortex-M4 Bus Fault Interrupt                  */
    UsageFault_IRQn         = -10,          /*!< 6 Cortex-M4 Usage Fault Interrupt                */
    SVCall_IRQn             = -5,           /*!< 11 Cortex-M4 SV Call Interrupt                   */
    DebugMonitor_IRQn       = -4,           /*!< 12 Cortex-M4 Debug Monitor Interrupt             */
    PendSV_IRQn             = -2,           /*!< 14 Cortex-M4 Pend SV Interrupt                   */
    SysTick_IRQn            = -1,           /*!< 15 Cortex-M4 System Tick Interrupt               */
/******  LPC43xx Specific Interrupt Numbers *******************************************************/
    DAC_IRQn                = 0,
    WIC_IRQn                = 1,
    DMA_IRQn                = 2,
    EDM_IRQn                = 3,
    SCI_IRQn                = 4,
    ETH_IRQn                = 5,
    SDIO_IRQn               = 6,
    LCD_IRQn                = 7,
    USB0_IRQn               = 8,
    USB1_IRQn               = 9,
    SCT_IRQn                = 10,
    OST_IRQn                = 11,
    TIMER0_IRQn             = 12,
    TIMER1_IRQn             = 13,
    TIMER2_IRQn             = 14,
    TIMER3_IRQn             = 15,
    MCPWM_IRQn              = 16,
    ADC0_IRQn               = 17,
    I2C0_IRQn               = 18,
    I2C1_IRQn               = 19,
    SPI_IRQn                = 20,
    ADC1_IRQn               = 21,
    SSP0_IRQn               = 22,
    SSP1_IRQn               = 23,
    UART0_IRQn              = 24,
    UART1_IRQn              = 25,
    UART2_IRQn              = 26,
    UART3_IRQn              = 27,
    I2S_IRQn                = 28,
    AES_IRQn                = 29,
    SPIFI_IRQn              = 30,
    SGPIO_IRQn              = 31,
} IRQn_Type;

/*
 * ==========================================================================
 * ---------- WIK Interrupt Number Definition --------------------------------
 * ==========================================================================
 */
typedef enum WIKn
{
    WIKnWAKEUP0     = 0,
    WIKnWAKEUP1     = 1,
    WIKnWAKEUP2     = 2,
    WIKnWAKEUP3     = 3,
    WIKnATIMER      = 4,
    WIKnRTCEVR      = 5,
    WIKnBODTRIP     = 6,
    WIKnWDT         = 7,
    WIKnETH         = 8,
    WIKnUSB0        = 9,
    //WIKnUSB1      = 10,
    WIKnEXT_INT     = 11,
    WIKnCCAN        = 12,
    WIKnTIMEROUT2   = 13,
    WIKnTIMEROUT6   = 14,
    WIKnQEI         = 15,
    WIKnTIMEROUT14  = 16,
    WIKnM0          = 17,
    WIKnM3          = 18,
    WIKnRESET       = 19
}WIKn_Type;

/*
 * ==========================================================================
 * ----------- Processor and Core Peripheral Section ------------------------
 * ==========================================================================
 */

/* Configuration of the Cortex-M4 Processor and Core Peripherals */
#define __MPU_PRESENT             1         /*!< MPU present or not                               */
#define __NVIC_PRIO_BITS          5         /*!< Number of Bits used for Priority Levels          */
#define __Vendor_SysTickConfig    0         /*!< Set to 1 if different SysTick Config is used     */


#ifdef CORE_M4
    #include "core_cm4.h"                   /* Cortex-M4 processor and core peripherals           */
#endif  
#ifdef CORE_M0
    #include "core_cm0.h"                   /* Cortex-M0 processor and core peripherals           */
#endif

#include "system_LPC43xx.h"                 /* System Header */


/******************************************************************************/
/*                Device Specific Peripheral registers structures             */
/******************************************************************************/

#if defined ( __CC_ARM   )
#pragma anon_unions
#endif

// Outclock selection:
// 0:  External Clock 0 (osc32k_clk_in)
// 1:  External Clock 1 (irc_clk_in)
// 2:  External Clock 2 (phy_rx_clk_in)
// 3:  External Clock 3 (phy_tx_clk_in)
// 4:  External Clock 4 (spifi0_clk_in)
// 5:  External Clock 5 (tck_in)
// 6:  XO50M 0
// 7:  PL550M 0
// 8:  PL160M 0 clkout
// 9:  PL160M 0 clkout120
// 10: PL160M 0 clkout240
// 11: IDIV 0
// 12: IDIV 1
// 13: IDIV 2
// 14: IDIV 3
// 15: IDIV 4

/*------------- Clock Generation Unit(CGU) -----------------------------------*/
typedef struct
{
    __IO uint32_t RCD0;                     /* 0x00 */
    __IO uint32_t RCD1;
    __IO uint32_t RCD2;
    __IO uint32_t RCD3;
       uint32_t RESERVED0;
    __IO uint32_t RFRQ;
    __IO uint32_t XO50M_0_C;
    __IO uint32_t PL550M_0_S;

    __IO uint32_t PL550M_0_C;               /* 0x20 */
    __IO uint32_t PL550M_0_M;
    __IO uint32_t PL550M_0_N;
    __IO uint32_t PL160M_0_S;
    __IO uint32_t PL160M_0_C;
    __IO uint32_t IDIVA_4_C;
    __IO uint32_t IDIVB_16_C;
    __IO uint32_t IDIVC_16_C;

    __IO uint32_t IDIVD_16_C;               /* 0x40 */
    __IO uint32_t IDIVE_256_C;
    __IO uint32_t BASE_SAFE_CLK;
    __IO uint32_t BASE_USB0_CLK;
    __IO uint32_t BASE_M0_CLK;
    __IO uint32_t BASE_USB1_CLK;
    __IO uint32_t BASE_M4_CLK;
    __IO uint32_t BASE_SPIFI0_CLK;

    __IO uint32_t BASE_SPI_CLK;             /* 0x60 */
    __IO uint32_t BASE_PHY_RX_CLK;
    __IO uint32_t BASE_PHY_TX_CLK;
    __IO uint32_t BASE_VPB1_CLK;
    __IO uint32_t BASE_VPB3_CLK;
    __IO uint32_t BASE_LCD_CLK;
    __IO uint32_t BASE_SCI_CLK;
    __IO uint32_t BASE_SDIO_CLK;

    __IO uint32_t BASE_SSP0_CLK;            /* 0x80 */
    __IO uint32_t BASE_SSP1_CLK;
    __IO uint32_t BASE_UART0_CLK;
    __IO uint32_t BASE_UART1_CLK;
    __IO uint32_t BASE_UART2_CLK;
    __IO uint32_t BASE_UART3_CLK;
    __IO uint32_t BASE_OUT_CLK;
    __IO uint32_t BASE_AOTEST_CLK;

    __IO uint32_t BASE_ISO_TCK;             /* 0xA0 */
    __IO uint32_t BASE_BSR_TCK;
    __IO uint32_t BASE_CLK_TESTSHELL;
    __IO uint32_t BASE_SPARE_CLK;
       uint32_t RESERVED1[788];

    __IO uint32_t RGC0;                     /* 0xD00 */
       uint32_t RESERVED2[181];

    __IO uint32_t INT_CLR_ENABLE;           /* 0xFD8 */
    __IO uint32_t INT_SET_ENABLE;
    __IO uint32_t INT_STATUS;               /* 0xFE0 */
    __IO uint32_t INT_ENABLE;
    __IO uint32_t INT_CLR_STATUS;
    __IO uint32_t INT_SET_STATUS;
       uint32_t RESERVED3;
    __IO uint32_t RBUS;
    __IO uint32_t REXT;
    __IO uint32_t RMID;
} LPC_CGU_TypeDef;



/*------------- Clock Control Unit(CCU1) -----------------------------------*/
typedef struct
{
    __IO uint32_t PM;                       /* 0x00 */
    __I  uint32_t BSTAT;
       uint32_t RESERVED0[62];
    __IO uint32_t CLK_APB3_BUS_CFG;         /* 0x100 + n * 0x100 + m * 0x08 */
    __I  uint32_t CLK_APB3_BUS_STAT;        /* 0x104 + n * 0x100 + m * 0x08 */
    __IO uint32_t CLK_APB3_I2C1_CFG;
    __I  uint32_t CLK_APB3_I2C1_STAT;
    __IO uint32_t CLK_APB3_DAC_CFG;
    __I  uint32_t CLK_APB3_DAC_STAT;
    __IO uint32_t CLK_APB3_ADC0_CFG;
    __I  uint32_t CLK_APB3_ADC0_STAT;
    __IO uint32_t CLK_APB3_ADC1_CFG;
    __I  uint32_t CLK_APB3_ADC1_STAT;
    __IO uint32_t CLK_APB3_CAN_CFG;
    __I  uint32_t CLK_APB3_CAN_STAT;
       uint32_t RESERVED1[52];
    __IO uint32_t CLK_APB1_BUS_CFG;         /* 0x200 */
    __I  uint32_t CLK_APB1_BUS_STAT;
    __IO uint32_t CLK_APB1_MOTOCON_CFG;
    __I  uint32_t CLK_APB1_MOTOCON_STAT;
    __IO uint32_t CLK_APB1_I2C0_CFG;
    __I  uint32_t CLK_APB1_I2C0_STAT;
    __IO uint32_t CLK_APB1_I2S_CFG;
    __I  uint32_t CLK_APB1_I2S_STAT;
       uint32_t RESERVED2[56];
    __IO uint32_t CLK_SPIFI_CFG;            /* 0x300 */
    __I  uint32_t CLK_SPIFI_STAT;
       uint32_t RESERVED3[62];
    __IO uint32_t CLK_M4_BUS_CFG;           // 0x400 
    __I  uint32_t CLK_M4_BUS_STAT;
    __IO uint32_t CLK_M4_SPIFI_CFG;
    __I  uint32_t CLK_M4_SPIFI_STAT;
    __IO uint32_t CLK_M4_GPIO_CFG;          // 0x410 
    __I  uint32_t CLK_M4_GPIO_STAT;
    __IO uint32_t CLK_M4_CLCD_CFG;
    __I  uint32_t CLK_M4_CLCD_STAT;
    __IO uint32_t CLK_M4_ETH6100_CFG;       // 0x420 
    __I  uint32_t CLK_M4_ETH6100_STAT;
    __IO uint32_t CLK_M4_USB9028_CFG;
    __I  uint32_t CLK_M4_USB9028_STAT;
    __IO uint32_t CLK_M4_MPMC_CFG;          // 0x430 
    __I  uint32_t CLK_M4_MPMC_STAT;
    __IO uint32_t CLK_M4_SDIO_CFG;
    __I  uint32_t CLK_M4_SDIO_STAT;
    __IO uint32_t CLK_M4_DMA_CFG;           // 0x440 
    __I  uint32_t CLK_M4_DMA_STAT;
    __IO uint32_t CLK_M4_M4CORE_CFG;
    __I  uint32_t CLK_M4_M4CORE_STAT;
    __IO uint32_t CLK_M4_USART_CFG;         // 0x450 
    __I  uint32_t CLK_M4_USART_STAT;
    __IO uint32_t CLK_M4_EVT_CFG;
    __I  uint32_t CLK_M4_EVT_STAT;
    __IO uint32_t CLK_M4_AES_CFG;           // 0x460 
    __I  uint32_t CLK_M4_AES_STAT;
    __IO uint32_t CLK_M4_SCT_CFG;
    __I  uint32_t CLK_M4_SCT_STAT;
    __IO uint32_t CLK_M4_USB3528_CFG;       // 
    __I  uint32_t CLK_M4_USB3528_STAT;      // 
    __IO uint32_t CLK_M4_MPMC_DIV_CFG;      // 
    __I  uint32_t CLK_M4_MPMC_DIV_STAT;     // 
    __I  uint32_t RESERVED5[32];
    __IO uint32_t CLK_M4_WWDT_CFG;            
    __I  uint32_t CLK_M4_WWDT_STAT;           
    __IO uint32_t CLK_M4_USART0_CFG;          
    __I  uint32_t CLK_M4_USART0_STAT;         
    __IO uint32_t CLK_M4_UART1_CFG;           
    __I  uint32_t CLK_M4_UART1_STAT;          
    __IO uint32_t CLK_M4_SSP0_CFG;            
    __I  uint32_t CLK_M4_SSP0_STAT;           
    __IO uint32_t CLK_M4_TIMER0_CFG;          
    __I  uint32_t CLK_M4_TIMER0_STAT;         
    __IO uint32_t CLK_M4_TIMER1_CFG;          
    __I  uint32_t CLK_M4_TIMER1_STAT;         
    __IO uint32_t CLK_M4_SCU_CFG;             
    __I  uint32_t CLK_M4_SCU_STAT;            
    __IO uint32_t CLK_M4_CREG_CFG;            
    __I  uint32_t CLK_M4_CREG_STAT;           
    __I  uint32_t RESERVED6[48];
    __IO uint32_t CLK_M4_RITIMER_CFG;         
    __I  uint32_t CLK_M4_RITIMER_STAT;        
    __IO uint32_t CLK_M4_USART2_CFG;          
    __I  uint32_t CLK_M4_USART2_STAT;        
    __IO uint32_t CLK_M4_USART3_CFG;          
    __I  uint32_t CLK_M4_USART3_STAT;         
    __IO uint32_t CLK_M4_TIMER2_CFG;          
    __I  uint32_t CLK_M4_TIMER2_STAT;         
    __IO uint32_t CLK_M4_TIMER3_CFG;          
    __I  uint32_t CLK_M4_TIMER3_STAT;         
    __IO uint32_t CLK_M4_SSP1_CFG;            
    __I  uint32_t CLK_M4_SSP1_STAT;           
    __IO uint32_t CLK_M4_QEI_CFG;             
    __I  uint32_t CLK_M4_QEI_STAT;            
    __I  uint32_t RESERVED7[114];
    __IO uint32_t CLK_USB0_CFG;               
    __I  uint32_t CLK_USB0_STAT;              
    __I  uint32_t RESERVED8[62];
    __IO uint32_t CLK_USB1_CFG;               
    __I  uint32_t CLK_USB1_STAT;              


} LPC_CCU1_TypeDef;



/*------------- Clock Control Unit(CCU2) -----------------------------------*/
typedef struct
{
    __IO uint32_t PM;                       /* 0x00 */
    __IO uint32_t BSTAT;
       uint32_t RESERVED0[62];
    __IO uint32_t CLK_SCI_CFG;              /* 0x100 */
    __IO uint32_t CLK_SCI_STAT;
       uint32_t RESERVED1[62];
    __IO uint32_t CLK_APB2_UART3_CFG;       /* 0x200 */
    __IO uint32_t CLK_APB2_UART3_STAT;
       uint32_t RESERVED2[62];
    __IO uint32_t CLK_APB2_UART2_CFG;       /* 0x300 */
    __IO uint32_t CLK_APB2_UART2_STAT;
       uint32_t RESERVED3[62];
    __IO uint32_t CLK_APB0_UART1_CFG;       /* 0x400 */
    __IO uint32_t CLK_APB0_UART1_STAT;
       uint32_t RESERVED4[62];
    __IO uint32_t CLK_APB0_UART0_CFG;       /* 0x500 */
    __IO uint32_t CLK_APB0_UART0_STAT;
       uint32_t RESERVED5[62];
    __IO uint32_t CLK_APB2_SSP1_CFG;        /* 0x600 */
    __IO uint32_t CLK_APB2_SSP1_STAT;
       uint32_t RESERVED6[62];              /* 0x700 */
    __IO uint32_t CLK_APB0_SSP0_CFG;
    __IO uint32_t CLK_APB0_SSP0_STAT;
       uint32_t RESERVED7[62];              /* 0x800 */
    __IO uint32_t CLK_SDIO_CFG;
    __IO uint32_t CLK_SDIO_STAT;
} LPC_CCU2_TypeDef;



/*------------- Configuration register(CREG) -----------------------------------*/
typedef struct
{
    __IO uint32_t IRCTRIM;              /* 0x000 */
    __IO uint32_t CREG0;                /* 0x004 */
    __IO uint32_t PMUCON;               /* 0x008 */
       uint32_t RESERVED0[61];
    __IO uint32_t M3SHADOW;             /* 0x100 */
       uint32_t RESERVED1;
    __IO uint32_t APER24K;
    __IO uint32_t CLKDIS;
    __IO uint32_t PER0DIS;              /* 0x110 */
    __IO uint32_t PER1DIS;              /* 0x114 */
    __IO uint32_t PERSELECT;            /* 0x118 */
    __IO uint32_t DMAREQSEL;            /* 0x11C */
       uint32_t RESERVED2[3];
    __IO uint32_t EMACCFG;              /* 0x12C */
       uint32_t RESERVED3[52];
    __IO uint32_t CHIPID;               /* 0x200 */
       uint32_t RESERVED4[63];
    __IO uint32_t EDMBASE;              /* 0x300 */
    __IO uint32_t EDMSRC;               /* 0x304 */
    __IO uint32_t M0SHADOW;             /* 0x308 */
    __IO uint32_t M0APERT;              /* 0x30C */
    __IO uint32_t M0DIS;                /* 0x310 */
       uint32_t RESERVED5[763];
    __IO uint32_t LOCK;                 /* 0xF00 */
} LPC_CREG_TypeDef;



/*------------- System Configuration Unit (SCU) -------------------------------*/
typedef struct
{
    __IO uint32_t SFSP0_0;    /* 0x000 */
    __IO uint32_t SFSP0_1;  /* 0x004 */

    uint32_t RESERVED0[30];

    __IO uint32_t SFSP1_0;  /* 0x080 */
    __IO uint32_t SFSP1_1;  /* 0x084 */
    __IO uint32_t SFSP1_2;  /* 0x088 */
    __IO uint32_t SFSP1_3;  /* 0x08C */
    __IO uint32_t SFSP1_4;  /* 0x090 */
    __IO uint32_t SFSP1_5;  /* 0x094 */
    __IO uint32_t SFSP1_6;  /* 0x098 */
    __IO uint32_t SFSP1_7;  /* 0x09C */
    __IO uint32_t SFSP1_8;  /* 0x0A0 */
    __IO uint32_t SFSP1_9;  /* 0x0A4 */
    __IO uint32_t SFSP1_10; /* 0x0A8 */
    __IO uint32_t SFSP1_11; /* 0x0AC */
    __IO uint32_t SFSP1_12; /* 0x0B0 */
    __IO uint32_t SFSP1_13; /* 0x0B4 */
    __IO uint32_t SFSP1_14; /* 0x0B8 */
    __IO uint32_t SFSP1_15; /* 0x0BC */
    __IO uint32_t SFSP1_16; /* 0x0C0 */
    __IO uint32_t SFSP1_17; /* 0x0C4 */
    __IO uint32_t SFSP1_18; /* 0x0C8 */
    __IO uint32_t SFSP1_19; /* 0x0CC */
    __IO uint32_t SFSP1_20; /* 0x0D0 */

    uint32_t RESERVED1[11];

    __IO uint32_t SFSP2_0;  /* 0x100 */
    __IO uint32_t SFSP2_1;  /* 0x104 */
    __IO uint32_t SFSP2_2;  /* 0x108 */
    __IO uint32_t SFSP2_3;  /* 0x10C */
    __IO uint32_t SFSP2_4;  /* 0x110 */
    __IO uint32_t SFSP2_5;  /* 0x114 */
    __IO uint32_t SFSP2_6;  /* 0x118 */
    __IO uint32_t SFSP2_7;  /* 0x11C */
    __IO uint32_t SFSP2_8;  /* 0x120 */
    __IO uint32_t SFSP2_9;  /* 0x124 */
    __IO uint32_t SFSP2_10; /* 0x128 */
    __IO uint32_t SFSP2_11; /* 0x12C */
    __IO uint32_t SFSP2_12; /* 0x130 */
    __IO uint32_t SFSP2_13; /* 0x134 */

    uint32_t RESERVED2[18];

    __IO uint32_t SFSP3_0;  /* 0x180 */
    __IO uint32_t SFSP3_1;  /* 0x184 */
    __IO uint32_t SFSP3_2;  /* 0x188 */
    __IO uint32_t SFSP3_3;  /* 0x18C */
    __IO uint32_t SFSP3_4;  /* 0x190 */
    __IO uint32_t SFSP3_5;  /* 0x194 */
    __IO uint32_t SFSP3_6;  /* 0x198 */
    __IO uint32_t SFSP3_7;  /* 0x19C */
    __IO uint32_t SFSP3_8;  /* 0x1A0 */

    uint32_t RESERVED3[23];

    __IO uint32_t SFSP4_0;  /* 0x200 */
    __IO uint32_t SFSP4_1;  /* 0x204 */
    __IO uint32_t SFSP4_2;  /* 0x208 */
    __IO uint32_t SFSP4_3;  /* 0x20C */
    __IO uint32_t SFSP4_4;  /* 0x210 */
    __IO uint32_t SFSP4_5;  /* 0x214 */
    __IO uint32_t SFSP4_6;  /* 0x218 */
    __IO uint32_t SFSP4_7;  /* 0x21C */
    __IO uint32_t SFSP4_8;  /* 0x220 */
    __IO uint32_t SFSP4_9;  /* 0x224 */
    __IO uint32_t SFSP4_10; /* 0x228 */

    uint32_t RESERVED4[21];

    __IO uint32_t SFSP5_0;  /* 0x280 */
    __IO uint32_t SFSP5_1;  /* 0x284 */
    __IO uint32_t SFSP5_2;  /* 0x288 */
    __IO uint32_t SFSP5_3;  /* 0x28C */
    __IO uint32_t SFSP5_4;  /* 0x290 */
    __IO uint32_t SFSP5_5;  /* 0x294 */
    __IO uint32_t SFSP5_6;  /* 0x298 */
    __IO uint32_t SFSP5_7;  /* 0x29C */

    uint32_t RESERVED5[25];

    __IO uint32_t SFSP6_0;  /* 0x304 */
    __IO uint32_t SFSP6_1;  /* 0x308 */
    __IO uint32_t SFSP6_2;  /* 0x30C */
    __IO uint32_t SFSP6_3;  /* 0x310 */
    __IO uint32_t SFSP6_4;  /* 0x314 */
    __IO uint32_t SFSP6_5;  /* 0x318 */
    __IO uint32_t SFSP6_6;  /* 0x31C */
    __IO uint32_t SFSP6_7;  /* 0x320 */
    __IO uint32_t SFSP6_8;  /* 0x324 */
    __IO uint32_t SFSP6_9;  /* 0x328 */
    __IO uint32_t SFSP6_10; /* 0x32C */
    __IO uint32_t SFSP6_11; /* 0x330 */
    __IO uint32_t SFSP6_12; /* 0x334 */

    uint32_t RESERVED6[18];

    __IO uint32_t SFSP7_0;  /* 0x380 */
    __IO uint32_t SFSP7_1;  /* 0x384 */
    __IO uint32_t SFSP7_2;  /* 0x388 */
    __IO uint32_t SFSP7_3;  /* 0x38C */
    __IO uint32_t SFSP7_4;  /* 0x390 */
    __IO uint32_t SFSP7_5;  /* 0x394 */
    __IO uint32_t SFSP7_6;  /* 0x398 */
    __IO uint32_t SFSP7_7;  /* 0x39C */

    uint32_t RESERVED7[24];

    __IO uint32_t SFSP8_0;  /* 0x400 */
    __IO uint32_t SFSP8_1;  /* 0x404 */
    __IO uint32_t SFSP8_2;  /* 0x408 */
    __IO uint32_t SFSP8_3;  /* 0x40C */
    __IO uint32_t SFSP8_4;  /* 0x410 */
    __IO uint32_t SFSP8_5;  /* 0x414 */
    __IO uint32_t SFSP8_6;  /* 0x418 */
    __IO uint32_t SFSP8_7;  /* 0x41C */
    __IO uint32_t SFSP8_8;  /* 0x420 */

    uint32_t RESERVED8[23];

    __IO uint32_t SFSP9_0;  /* 0x480 */
    __IO uint32_t SFSP9_1;  /* 0x484 */
    __IO uint32_t SFSP9_2;  /* 0x488 */
    __IO uint32_t SFSP9_3;  /* 0x48C */
    __IO uint32_t SFSP9_4;  /* 0x490 */
    __IO uint32_t SFSP9_5;  /* 0x494 */
    __IO uint32_t SFSP9_6;  /* 0x498 */
    __IO uint32_t SFSP9_7;  /* 0x49C */
    __IO uint32_t SFSP9_8;  /* 0x4A0 */
    __IO uint32_t SFSP9_9;  /* 0x4A4 */
    __IO uint32_t SFSP9_10; /* 0x4A8 */
    __IO uint32_t SFSP9_11; /* 0x4AC */
    __IO uint32_t SFSP9_12; /* 0x4B0 */
    __IO uint32_t SFSP9_13; /* 0x4B4 */
    __IO uint32_t SFSP9_14; /* 0x4B8 */

    uint32_t RESERVED9[17];

    __IO uint32_t SFSPA_0;  /* 0x500 */
    __IO uint32_t SFSPA_1;  /* 0x504 */
    __IO uint32_t SFSPA_2;  /* 0x508 */
    __IO uint32_t SFSPA_3;  /* 0x50C */
    __IO uint32_t SFSPA_4;  /* 0x510 */

    uint32_t RESERVED11[27];

    __IO uint32_t SFSPB_0;  /* 0x580 */
    __IO uint32_t SFSPB_1;  /* 0x584 */
    __IO uint32_t SFSPB_2;  /* 0x588 */
    __IO uint32_t SFSPB_3;  /* 0x58C */
    __IO uint32_t SFSPB_4;  /* 0x590 */
    __IO uint32_t SFSPB_5;  /* 0x594 */
    __IO uint32_t SFSPB_6;  /* 0x598 */

    uint32_t RESERVED12[25];

    __IO uint32_t SFSPC_0;  /* 0x600 */
    __IO uint32_t SFSPC_1;  /* 0x604 */
    __IO uint32_t SFSPC_2;  /* 0x608 */
    __IO uint32_t SFSPC_3;  /* 0x60C */
    __IO uint32_t SFSPC_4;  /* 0x610 */
    __IO uint32_t SFSPC_5;  /* 0x614 */
    __IO uint32_t SFSPC_6;  /* 0x618 */
    __IO uint32_t SFSPC_7;  /* 0x61C */
    __IO uint32_t SFSPC_8;  /* 0x620 */
    __IO uint32_t SFSPC_9;  /* 0x624 */
    __IO uint32_t SFSPC_10; /* 0x628 */
    __IO uint32_t SFSPC_11; /* 0x62C */
    __IO uint32_t SFSPC_12; /* 0x630 */
    __IO uint32_t SFSPC_13; /* 0x634 */
    __IO uint32_t SFSPC_14; /* 0x638 */

    uint32_t RESERVED13[17];

    __IO uint32_t SFSPD_0;  /* 0x680 */
    __IO uint32_t SFSPD_1;  /* 0x684 */
    __IO uint32_t SFSPD_2;  /* 0x688 */
    __IO uint32_t SFSPD_3;  /* 0x68C */
    __IO uint32_t SFSPD_4;  /* 0x690 */
    __IO uint32_t SFSPD_5;  /* 0x694 */
    __IO uint32_t SFSPD_6;  /* 0x698 */
    __IO uint32_t SFSPD_7;  /* 0x69C */
    __IO uint32_t SFSPD_8;  /* 0x6A0 */
    __IO uint32_t SFSPD_9;  /* 0x6A4 */
    __IO uint32_t SFSPD_10; /* 0x6A8 */
    __IO uint32_t SFSPD_11; /* 0x6AC */
    __IO uint32_t SFSPD_12; /* 0x6B0 */
    __IO uint32_t SFSPD_13; /* 0x6B4 */
    __IO uint32_t SFSPD_14; /* 0x6B8 */
    __IO uint32_t SFSPD_15; /* 0x6BC */
    __IO uint32_t SFSPD_16; /* 0x6C0 */

    uint32_t RESERVED14[15];

    __IO uint32_t SFSPE_0;  /* 0x700 */
    __IO uint32_t SFSPE_1;  /* 0x704 */
    __IO uint32_t SFSPE_2;  /* 0x708 */
    __IO uint32_t SFSPE_3;  /* 0x70C */
    __IO uint32_t SFSPE_4;  /* 0x710 */
    __IO uint32_t SFSPE_5;  /* 0x714 */
    __IO uint32_t SFSPE_6;  /* 0x718 */
    __IO uint32_t SFSPE_7;  /* 0x71C */
    __IO uint32_t SFSPE_8;  /* 0x720 */
    __IO uint32_t SFSPE_9;  /* 0x724 */
    __IO uint32_t SFSPE_10; /* 0x728 */
    __IO uint32_t SFSPE_11; /* 0x72C */
    __IO uint32_t SFSPE_12; /* 0x730 */
    __IO uint32_t SFSPE_13; /* 0x734 */
    __IO uint32_t SFSPE_14; /* 0x738 */
    __IO uint32_t SFSPE_15; /* 0x73C */

    uint32_t RESERVED15[16];

    __IO uint32_t SFSPF_0;  /* 0x780 */
    __IO uint32_t SFSPF_1;  /* 0x784 */
    __IO uint32_t SFSPF_2;  /* 0x788 */
    __IO uint32_t SFSPF_3;  /* 0x78C */
    __IO uint32_t SFSPF_4;  /* 0x790 */
    __IO uint32_t SFSPF_5;  /* 0x794 */
    __IO uint32_t SFSPF_6;  /* 0x798 */
    __IO uint32_t SFSPF_7;  /* 0x79C */
    __IO uint32_t SFSPF_8;  /* 0x7A0 */
    __IO uint32_t SFSPF_9;  /* 0x7A4 */
    __IO uint32_t SFSPF_10; /* 0x7A8 */
    __IO uint32_t SFSPF_11; /* 0x7AC */

    uint32_t RESERVED16[276];

    __IO uint32_t SFSPCLK0; /* 0xC00 */
    __IO uint32_t SFSPCLK1; /* 0xC04 */
    __IO uint32_t SFSPCLK2; /* 0xC08 */
    __IO uint32_t SFSPCLK3; /* 0xC0C */

    uint32_t RESERVED17[28];

    __IO uint32_t SFSPAIM;  /* 0xC80 */
    __IO uint32_t SFSPI2C;  /* 0xC84 */
} LPC_SCU_TypeDef;



/*------------- General Purpose Input/Output (GPIO) --------------------------*/
typedef struct
{
    union
    {
        __IO uint32_t DIR;
        struct
        {
            __IO uint16_t DIRL;
            __IO uint16_t DIRH;
        };
        struct
        {
            __IO uint8_t  DIR0;
            __IO uint8_t  DIR1;
            __IO uint8_t  DIR2;
            __IO uint8_t  DIR3;
        };
    };

    uint32_t RESERVED0[3];
    union
    {
        __IO uint32_t MASK;
        struct
        {
            __IO uint16_t MASKL;
            __IO uint16_t MASKH;
        };
        struct
        {
            __IO uint8_t  MASK0;
            __IO uint8_t  MASK1;
            __IO uint8_t  MASK2;
            __IO uint8_t  MASK3;
        };
    };
    union
    {
        __IO uint32_t PIN;
        struct
        {
            __IO uint16_t PINL;
            __IO uint16_t PINH;
        };
        struct
        {
            __IO uint8_t  PIN0;
            __IO uint8_t  PIN1;
            __IO uint8_t  PIN2;
            __IO uint8_t  PIN3;
        };
    };

    union
    {
        __IO uint32_t SET;
        struct
        {
            __IO uint16_t SETL;
            __IO uint16_t SETH;
        };
        struct
        {
            __IO uint8_t  SET0;
            __IO uint8_t  SET1;
            __IO uint8_t  SET2;
            __IO uint8_t  SET3;
        };
    };

    union
    {
        __O  uint32_t CLR;
        struct
        {
            __O  uint16_t CLRL;
            __O  uint16_t CLRH;
        };
        struct
        {
            __O  uint8_t  CLR0;
            __O  uint8_t  CLR1;
            __O  uint8_t  CLR2;
            __O  uint8_t  CLR3;
        };
    };
} LPC_GPIO_TypeDef;


typedef struct
{
    __I  uint32_t IntStatus;
    __I  uint32_t IO0IntStatR;
    __I  uint32_t IO0IntStatF;
    __O  uint32_t IO0IntClr;
    __IO uint32_t IO0IntEnR;
    __IO uint32_t IO0IntEnF;
       uint32_t RESERVED0[3];
    __I  uint32_t IO2IntStatR;
    __I  uint32_t IO2IntStatF;
    __O  uint32_t IO2IntClr;
    __IO uint32_t IO2IntEnR;
    __IO uint32_t IO2IntEnF;
} LPC_GPIOINT_TypeDef;



/*------------- Power Management Controller (PMC) -----------------------------------*/
typedef struct
{
    __IO uint32_t SLEEP0_HW_ENA;            /* 0x000 */
       uint32_t RESERVED0;
    __IO uint32_t SLEEP0_HW_EDG_LVL;        /* 0x008 */
       uint32_t RESERVED1[3];
    __IO uint32_t SLEEP0_CONFIG;            /* 0x018 */
    __IO uint32_t SLEEP0_MODE;              /* 0x01C */
       uint32_t RESERVED2[24];
    __IO uint32_t WAKE0_HW_ENA;             /* 0x080 */
       uint32_t RESERVED3;
    __IO uint32_t WAKE0_HW_EDG_LVL;         /* 0x088 */
       uint32_t RESERVED4[67];
    __IO uint32_t PSU_OPT;                  /* 0x198 */
       uint32_t RESERVED5[2];
    __IO uint32_t PSU_DELAY;                /* 0x1A4 */
       uint32_t RESERVED6;
    __IO uint32_t POST_PSU_DELAY;           /* 0x1AC */
} LPC_PMC_TypeDef;



/*------------- Timer (TIM) --------------------------------------------------*/
/*
typedef struct
{
    __IO uint32_t IR;
    __IO uint32_t TCR;
    __IO uint32_t TC;
    __IO uint32_t PR;
    __IO uint32_t PC;
    __IO uint32_t MCR;
    __IO uint32_t MR0;
    __IO uint32_t MR1;
    __IO uint32_t MR2;
    __IO uint32_t MR3;
    __IO uint32_t CCR;
    __I  uint32_t CR0;
    __I  uint32_t CR1;
       uint32_t RESERVED0[2];
    __IO uint32_t EMR;
       uint32_t RESERVED1[12];
    __IO uint32_t CTCR;
} LPC_TIM_TypeDef;
*/
typedef struct {                            /*!< (@ 0x400xx000) TIMERn Structure       */
  __IO uint32_t IR;                         /*!< (@ 0x400xx000) Interrupt Register. The IR can be written to clear interrupts. The IR can be read to identify which of eight possible interrupt sources are pending. */
  __IO uint32_t TCR;                        /*!< (@ 0x400xx004) Timer Control Register. The TCR is used to control the Timer Counter functions. The Timer Counter can be disabled or reset through the TCR. */
  __IO uint32_t TC;                         /*!< (@ 0x400xx008) Timer Counter. The 32 bit TC is incremented every PR+1 cycles of PCLK. The TC is controlled through the TCR. */
  __IO uint32_t PR;                         /*!< (@ 0x400xx00C) Prescale Register. The Prescale Counter (below) is equal to this value, the next clock increments the TC and clears the PC. */
  __IO uint32_t PC;                         /*!< (@ 0x400xx010) Prescale Counter. The 32 bit PC is a counter which is incremented to the value stored in PR. When the value in PR is reached, the TC is incremented and the PC is cleared. The PC is observable and controllable through the bus interface. */
  __IO uint32_t MCR;                        /*!< (@ 0x400xx014) Match Control Register. The MCR is used to control if an interrupt is generated and if the TC is reset when a Match occurs. */
  __IO uint32_t MR[4];                      /*!< (@ 0x400xx018) Match Register. MR can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate an interrupt every time MR matches the TC. */
  __IO uint32_t CCR;                        /*!< (@ 0x400xx028) Capture Control Register. The CCR controls which edges of the capture inputs are used to load the Capture Registers and whether or not an interrupt is generated when a capture takes place. */
  __IO uint32_t CR[4];                      /*!< (@ 0x400xx02C) Capture Register. CR is loaded with the value of TC when there is an event on the CAPn.0 input. */
  __IO uint32_t EMR;                        /*!< (@ 0x400xx03C) External Match Register. The EMR controls the external match pins MATn.0-3 (MAT0.0-3 and MAT1.0-3 respectively). */
  __I  uint32_t RESERVED0[12];
  __IO uint32_t CTCR;                       /*!< (@ 0x400xx070) Count Control Register. The CTCR selects between Timer and Counter mode, and in Counter mode selects the signal and edge(s) for counting. */
} LPC_TIMERn_Type;



/*------------- Pulse-Width Modulation (PWM) ---------------------------------*/
typedef struct
{
    __IO uint32_t IR;
    __IO uint32_t TCR;
    __IO uint32_t TC;
    __IO uint32_t PR;
    __IO uint32_t PC;
    __IO uint32_t MCR;
    __IO uint32_t MR0;
    __IO uint32_t MR1;
    __IO uint32_t MR2;
    __IO uint32_t MR3;
    __IO uint32_t CCR;
    __I  uint32_t CR0;
    __I  uint32_t CR1;
    __I  uint32_t CR2;
    __I  uint32_t CR3;
       uint32_t RESERVED0;
    __IO uint32_t MR4;
    __IO uint32_t MR5;
    __IO uint32_t MR6;
    __IO uint32_t PCR;
    __IO uint32_t LER;
       uint32_t RESERVED1[7];
    __IO uint32_t CTCR;
} LPC_PWM_TypeDef;



/*------------- Universal Asynchronous Receiver Transmitter (UART) -----------*/
typedef struct
{
    union
    {
      __I  uint32_t  RBR;               /* 0x0000 */
      __O  uint32_t  THR;               /* 0x0000 */
      __IO uint32_t  DLL;               /* 0x0000 */
    };

    union
    {
      __IO uint32_t  DLM;               /* 0x0004 */
      __IO uint32_t  IER;               /* 0x0004 */
    };

    union
    {
      __I  uint32_t  IIR;               /* 0x0008 */
      __O  uint32_t  FCR;               /* 0x0008 */
    };

    __IO uint32_t  LCR;             /* 0x000C */
       uint32_t  RESERVED1;         /* 0x0010 */
    __I  uint32_t  LSR;             /* 0x0014 */
       uint32_t  RESERVED2;         /* 0x0018 */
    __IO uint32_t  SCR;             /* 0x001C */
    __IO uint32_t  ACR;             /* 0x0020 */
    __IO uint32_t  ICR;             /* 0x0024 */
    __IO uint32_t  FDR;             /* 0x0028 */
       uint32_t  RESERVED3[5];          /* 0x002C */
    __IO uint32_t  HDEN;                /* 0x0040 */
       uint32_t  RESERVED4;         /* 0x0044 */
       uint32_t  SCICTRL;           /* 0x0048 */
    __IO uint32_t  RS485CTRL;           /* 0x004C */
    __IO uint32_t  ADRMATCH;            /* 0x0050 */
    __IO uint32_t  RS485DLY;            /* 0x0054 */

    union
    {
      __I  uint32_t  FIFOLVL;           /* 0x0058 */
      __IO uint32_t  SYNCCTRL;          /* 0x0058 */
    };
    __IO uint32_t  TER;             /* 0x005C */
} LPC_UART0_2_3_TypeDef;

typedef struct
{
    union
    {
      __I  uint8_t  RBR;
      __O  uint8_t  THR;
      __IO uint8_t  DLL;
           uint32_t RESERVED0;
    };

    union
    {
      __IO uint8_t  DLM;
      __IO uint32_t IER;
    };

    union
    {
      __I  uint32_t IIR;
      __O  uint8_t  FCR;
    };

    __IO uint8_t  LCR;
       uint8_t  RESERVED1[3];
    __IO uint8_t  MCR;
       uint8_t  RESERVED2[3];
    __I  uint8_t  LSR;
       uint8_t  RESERVED3[3];
    __I  uint8_t  MSR;
       uint8_t  RESERVED4[3];
    __IO uint8_t  SCR;
       uint8_t  RESERVED5[3];
    __IO uint32_t ACR;
       uint32_t RESERVED6;
    __IO uint32_t FDR;
       uint32_t RESERVED7;
    __IO uint8_t  TER;
       uint8_t  RESERVED8[27];
    __IO uint8_t  RS485CTRL;
       uint8_t  RESERVED9[3];
    __IO uint8_t  ADRMATCH;
       uint8_t  RESERVED10[3];
    __IO uint8_t  RS485DLY;
       uint8_t  RESERVED11[3];
    __I  uint8_t  FIFOLVL;
} LPC_UART1_TypeDef;



/*------------- Serial Peripheral Interface (SPI) ----------------------------*/
typedef struct
{
    __IO uint32_t SPCR;
    __I  uint32_t SPSR;
    __IO uint32_t SPDR;
    __IO uint32_t SPCCR;
       uint32_t RESERVED0[3];
    __IO uint32_t SPINT;
} LPC_SPI_TypeDef;



/*------------- Synchronous Serial Communication (SSP) -----------------------*/
typedef struct
{
    __IO uint32_t CR0;
    __IO uint32_t CR1;
    __IO uint32_t DR;
    __I  uint32_t SR;
    __IO uint32_t CPSR;
    __IO uint32_t IMSC;
    __IO uint32_t RIS;
    __IO uint32_t MIS;
    __IO uint32_t ICR;
    __IO uint32_t DMACR;
} LPC_SSP_TypeDef;



/*------------- Inter-Integrated Circuit (I2C) -------------------------------*/
typedef struct
{
    __IO uint32_t CONSET;
    __I  uint32_t STAT;
    __IO uint32_t DAT;
    __IO uint32_t ADR0;
    __IO uint32_t SCLH;
    __IO uint32_t SCLL;
    __O  uint32_t CONCLR;
    __IO uint32_t MMCTRL;
    __IO uint32_t ADR1;
    __IO uint32_t ADR2;
    __IO uint32_t ADR3;
    __I  uint32_t DATA_BUFFER;
    __IO uint32_t MASK0;
    __IO uint32_t MASK1;
    __IO uint32_t MASK2;
    __IO uint32_t MASK3;
} LPC_I2C_TypeDef;

/*------------- Inter IC Sound (I2S) -----------------------------------------*/
typedef struct
{
    __IO uint32_t DAO;
    __IO uint32_t DAI;
    __O  uint32_t TXFIFO;
    __I  uint32_t RXFIFO;
    __I  uint32_t STATE;
    __IO uint32_t DMA1;
    __IO uint32_t DMA2;
    __IO uint32_t IRQ;
    __IO uint32_t TXRATE;
    __IO uint32_t RXRATE;
    __IO uint32_t TXBITRATE;
    __IO uint32_t RXBITRATE;
    __IO uint32_t TXMODE;
    __IO uint32_t RXMODE;
} LPC_I2S_TypeDef;

/*------------- Repetitive interrupt timer (RIT) ----------------------------------------------*/
typedef struct
{
    __IO uint32_t COMPVAL;
    __IO uint32_t MASK;
    __IO uint8_t  CTRL;
       uint8_t  RESERVED0[3];
    __IO uint32_t COUNTER;
} LPC_RIT_TypeDef;

/*------------- Alarm Clock(ATIMER) ------------------------------------------*/
typedef struct
{
    __IO uint32_t TC;                   /* 0x000 */
    __IO uint32_t PRESET;               /* 0x004 */
       uint32_t RESERVED0[1012];
    __IO uint32_t CLREN;                /* 0xFD8 */
    __IO uint32_t SETEN;
    __IO uint32_t STATUS;
    __IO uint32_t ENA;
    __IO uint32_t CLRSTAT;
    __IO uint32_t SETSTAT;
} LPC_ATIMER_TypeDef;


/*------------- WIC ------------------------------------------*/
typedef struct
{
    __IO uint32_t HILO;                /* 0x000 */
    __IO uint32_t EDGE;              /* 0x004 */
       uint32_t RESERVED0[1012];
    __IO uint32_t CLREN;                 /* 0xFD8 */
    __IO uint32_t SETEN;
    __IO uint32_t STATUS;
    __IO uint32_t ENA;
    __IO uint32_t CLRSTAT;
    __IO uint32_t SETSTAT;
} LPC_WIC_TypeDef;

/*------------- Real-Time Clock (RTC) ----------------------------------------*/
typedef struct
{
    __IO uint32_t ILR;          // 0x000
       uint32_t RESERVED0;      // 0x004
    __IO uint32_t CCR;          // 0x008
    __IO uint32_t CIIR;         // 0x00C
    __IO uint32_t AMR;          // 0x010
    __I  uint32_t CTIME0;           // 0x014
    __I  uint32_t CTIME1;           // 0x018
    __I  uint32_t CTIME2;           // 0x01C
    __IO uint32_t SEC;          // 0x020
    __IO uint32_t MIN;          // 0x024
    __IO uint32_t HOUR;         // 0x028
    __IO uint32_t DOM;          // 0x02C
    __IO uint32_t DOW;          // 0x030
    __IO uint32_t DOY;          // 0x034
    __IO uint32_t MONTH;            // 0x038
    __IO uint32_t YEAR;         // 0x03C
    __IO uint32_t CALIBRATION;  // 0x040
       uint32_t RESERVED1[7];   // 0x044
    __IO uint32_t ALSEC;            // 0x060
    __IO uint32_t ALMIN;            // 0x064
    __IO uint32_t ALHRS;            // 0x068
    __IO uint32_t ALDOM;            // 0x06C
    __IO uint32_t ALDOW;            // 0x070
    __IO uint32_t ALDOY;            // 0x074
    __IO uint32_t ALMON;            // 0x078
    __IO uint32_t ALYRS;            // 0x07C
    __IO uint32_t ERSTAT;           // 0x080
    __IO uint32_t ERCTRL;           // 0x084
    __IO uint32_t ERCNTRS;      // 0x088
       uint32_t RESERVED22;     // 0x08C
    __IO uint32_t ERFIRSTSTAMP0;    // 0x090
    __IO uint32_t ERFIRSTSTAMP1;    // 0x094
    __IO uint32_t ERFIRSTSTAMP2;    // 0x098
       uint32_t RESERVED2;      // 0x09C
    __IO uint32_t ERLASSTAMP0;  // 0x0A0
    __IO uint32_t ERLASSTAMP1;  // 0x0A4
    __IO uint32_t ERLASSTAMP2;  // 0x0A8
} LPC_RTC_TypeDef;


/*------------- Watchdog Timer (WDT) -----------------------------------------*/
typedef struct
{
    __IO uint8_t  MOD;
       uint8_t  RESERVED0[3];
    __IO uint32_t TC;
    __IO uint32_t FEED;
    __I  uint32_t TV;
       uint32_t CLKSEL;
    __IO uint32_t WARNINT;
    __IO uint32_t WINDOW;
} LPC_WDT_TypeDef;


/*------------- Analog-to-Digital Converter (ADC) ----------------------------*/
typedef struct
{
    __IO uint32_t CR;
    __IO uint32_t GDR;
       uint32_t RESERVED0;
    __IO uint32_t INTEN;
    __I  uint32_t DR[8];
    __I  uint32_t STAT;
    __IO uint32_t TRM;
} LPC_ADC_TypeDef;


/*------------- Digital-to-Analog Converter (DAC) ----------------------------*/
typedef struct
{
    __IO uint32_t CR;
    __IO uint32_t CTRL;
    __IO uint16_t CNTVAL;
} LPC_DAC_TypeDef;


/*------------- Motor Control Pulse-Width Modulation (MCPWM) -----------------*/
typedef struct
{
    __I  uint32_t MCCON;            /* 0x000 PWM Contl read */
    __O  uint32_t MCCON_SET;        /* 0x004 PWM Contl set */
    __O  uint32_t MCCON_CLR;        /* 0x008 PWM Contl clear */
    __I  uint32_t MCCAPCON;         /* 0x00C Capture Contl read */
    __O  uint32_t MCCAPCON_SET;     /* 0x010 Capture Contl set */
    __O  uint32_t MCCAPCON_CLR;     /* 0x014 Event Contl clear */
    __IO uint32_t MCTC0;            /* 0x018 Timer Counter register, channel 0 */
    __IO uint32_t MCTC1;            /* 0x01C Timer Counter register, channel 1 */
    __IO uint32_t MCTC2;            /* 0x020 Timer Counter register, channel 2 */
    __IO uint32_t MCLIM0;           /* 0x024 Limit register, channel 0  */
    __IO uint32_t MCLIM1;           /* 0x028 Limit register, channel 1  */
    __IO uint32_t MCLIM2;           /* 0x02C Limit register, channel 2  */
    __IO uint32_t MCMAT0;           /* 0x030 Match register, channel 0  */
    __IO uint32_t MCMAT1;           /* 0x034 Match register, channel 1  */
    __IO uint32_t MCMAT2;           /* 0x038 Match register, channel 2  */
    __IO uint32_t MCDT;             /* 0x03C Dead time register  */
    __IO uint32_t MCCP;             /* 0x040 Communication Pattern register */
    __I  uint32_t MCCAP0;           /* 0x044 Capture register, channel 0 */
    __I  uint32_t MCCAP1;           /* 0x048 Capture register, channel 1 */
    __I  uint32_t MCCAP2;           /* 0x04C Capture register, channel 2 */
    __I  uint32_t MCINTEN;          /* 0x050 Interrupt Enable read */
    __O  uint32_t MCINTEN_SET;      /* 0x054 Interrupt Enable set */
    __O  uint32_t MCINTEN_CLR;      /* 0x058 Interrupt Enable clear */
    __I  uint32_t MCCNTCON;         /* 0x05C Count Contl read */
    __O  uint32_t MCCNTCON_SET;     /* 0x060 Count Contl set */
    __O  uint32_t MCCNTCON_CLR;     /* 0x064 Count Contl clear */
    __I  uint32_t MCINTF;           /* 0x068 Interrupt flags read */
    __O  uint32_t MCINTF_SET;       /* 0x06C Interrupt flags set */
    __O  uint32_t MCINTF_CLR;       /* 0x070 Interrupt flags clear */
    __O  uint32_t MCCAP_CLR;        /* 0x074 Capture clear */
} LPC_MCPWM_TypeDef;


/*------------- Quadrature Encoder Interface (QEI) ---------------------------*/
typedef struct
{
    __O  uint32_t CON;          /* 0x000 */
    __I  uint32_t STAT;         /* 0x004 */
    __IO uint32_t CONF;         /* 0x008 */
    __I  uint32_t POS;          /* 0x00C */
    __IO uint32_t MAXPOS;       /* 0x010 */
    __IO uint32_t CMPOS0;       /* 0x014 */
    __IO uint32_t CMPOS1;       /* 0x018 */
    __IO uint32_t CMPOS2;       /* 0x01C */
    __I  uint32_t INXCNT;       /* 0x020 */
    __IO uint32_t INXCMP;       /* 0x024 */
    __IO uint32_t LOAD;         /* 0x028 */
    __I  uint32_t TIME;         /* 0x02C */
    __I  uint32_t VEL;          /* 0x030 */
    __I  uint32_t CAP;          /* 0x034 */
    __IO uint32_t VELCOMP;      /* 0x038 */
    __IO uint32_t FILTERPHA;    /* 0x03C */
    __IO uint32_t FILTERPHB;    /* 0x040 */
    __IO uint32_t FILTERINX;    /* 0x044 */
       uint32_t RESERVED0[996];
    __O  uint32_t IEC;          /* 0xFD8 */
    __O  uint32_t IES;          /* 0xFDC */
    __I  uint32_t INTSTAT;      /* 0xFE0 */
    __I  uint32_t IE;           /* 0xFE4 */
    __O  uint32_t CLR;          /* 0xFE8 */
    __O  uint32_t SET;          /* 0xFEC */
       uint32_t RESERVED1[3];
       uint32_t MOD_ID;         /* 0xFFC */
} LPC_QEI_TypeDef;

typedef struct                          /* Controller Registers               */
{
    __IO uint32_t CAN_CNTL;         // 0x000
    __IO uint32_t CAN_STAT;         // 0x004
    __IO uint32_t CAN_EC;           // 0x008
    __IO uint32_t CAN_BT;           // 0x00C
    __IO uint32_t CAN_INT;          // 0x010
    __IO uint32_t CAN_TEST;         // 0x014
    __IO uint32_t CAN_BRPE;         // 0x018
         uint32_t RESERVED0;        // 0x01C
    __IO uint32_t CAN_IF1_CMDREQ;   // 0x020
    __IO uint32_t CAN_IF1_CMDMSK;   // 0x024
    __IO uint32_t CAN_IF1_MSK1;     // 0x028
    __IO uint32_t CAN_IF1_MSK2;     // 0x02C
    __IO uint32_t CAN_IF1_ARB1;     // 0x030
    __IO uint32_t CAN_IF1_ARB2;     // 0x034
    __IO uint32_t CAN_IF1_MCTRL;    // 0x038
    __IO uint32_t CAN_IF1_DA1;      // 0x03C
    __IO uint32_t CAN_IF1_DA2;      // 0x040
    __IO uint32_t CAN_IF1_DB1;      // 0x044
    __IO uint32_t CAN_IF1_DB2;      // 0x048
         uint32_t RESERVED1[13];
    __IO uint32_t CAN_IF2_CMDREQ;   // 0x080
    __IO uint32_t CAN_IF2_CMDMSK;   // 0x084
    __IO uint32_t CAN_IF2_MSK1;     // 0x088
    __IO uint32_t CAN_IF2_MSK2;     // 0x08C
    __IO uint32_t CAN_IF2_ARB1;     // 0x090
    __IO uint32_t CAN_IF2_ARB2;     // 0x094
    __IO uint32_t CAN_IF2_MCTRL;    // 0x098
    __IO uint32_t CAN_IF2_DA1;      // 0x09C
    __IO uint32_t CAN_IF2_DA2;      // 0x0A0
    __IO uint32_t CAN_IF2_DB1;      // 0x0A4
    __IO uint32_t CAN_IF2_DB2;      // 0x0A8
         uint32_t RESERVED2[21];
    __IO uint32_t CAN_TXREQ1;       // 0x100
    __IO uint32_t CAN_TXREQ2;       // 0x104
         uint32_t RESERVED3[6];
    __IO uint32_t CAN_ND1;          // 0x120
    __IO uint32_t CAN_ND2;          // 0x124
         uint32_t RESERVED4[6];
    __IO uint32_t CAN_IR1;          // 0x140
    __IO uint32_t CAN_IR2;          // 0x144
         uint32_t RESERVED5[6];
    __IO uint32_t CAN_MSGV1;        // 0x160
    __IO uint32_t CAN_MSGV2;        // 0x164
         uint32_t RESERVED6[6];
    __IO uint32_t CAN_CLKDIV;       // 0x180
} LPC_CCAN_TypeDef;

/*------------- General Purpose Direct Memory Access (GPDMA) -----------------*/
typedef struct                          /* Common Registers                   */
{
    __I  uint32_t IntStat;
    __I  uint32_t IntTCStat;
    __O  uint32_t IntTCClear;
    __I  uint32_t IntErrStat;
    __O  uint32_t IntErrClr;
    __I  uint32_t RawIntTCStat;
    __I  uint32_t RawIntErrStat;
    __I  uint32_t EnbldChns;
    __IO uint32_t SoftBReq;
    __IO uint32_t SoftSReq;
    __IO uint32_t SoftLBReq;
    __IO uint32_t SoftLSReq;
    __IO uint32_t Config;
    __IO uint32_t Sync;
} LPC_GPDMA_TypeDef;

typedef struct                          /* Channel Registers                  */
{
    __IO uint32_t CSrcAddr;
    __IO uint32_t CDestAddr;
    __IO uint32_t CLLI;
    __IO uint32_t CControl;
    __IO uint32_t CConfig;
} LPC_GPDMACH_TypeDef;


/*------------- Ethernet Media Access Controller (EMAC) ----------------------*/
typedef struct
{
    __IO uint32_t MAC_CONFIG;                   /* MAC Registers                  */
    __IO uint32_t MAC_FRAME_FILTER;
    __IO uint32_t MAC_HASHTABLE_HIGH;
    __IO uint32_t MAC_HASHTABLE_LOW;
    __IO uint32_t MAC_GMII_ADDR;
    __IO uint32_t MAC_GMII_DATA;
    __IO uint32_t MAC_FLOW_CTRL;
    __IO uint32_t MAC_VLAN_TAG;
    __IO uint32_t MAC_VER;
    __I  uint32_t MAC_DEBUG;
    __IO uint32_t MAC_RWAKE_FRFLT;
    __IO uint32_t MAC_PMT_CTRL_STAT;
       uint32_t RESERVED0[2];
    __I  uint32_t MAC_INTR;
    __IO uint32_t MAC_INTR_MASK;
    __IO uint32_t MAC_ADDR0_HIGH;
    __IO uint32_t MAC_ADDR0_LOW;
       uint32_t RESERVED1[430];
    __IO uint32_t MAC_TIMESTP_CTRL;
       uint32_t RESERVED2[575];
    __IO uint32_t DMA_BUS_MODE;               /* DMA Registers  */
    __IO uint32_t DMA_TRANS_POLL_DEMAND;
    __IO uint32_t DMA_REC_POLL_DEMAND;
    __IO uint32_t DMA_REC_DES_ADDR;
    __IO uint32_t DMA_TRANS_DES_ADDR;
    __IO uint32_t DMA_STAT;
    __IO uint32_t DMA_OP_MODE;
    __IO uint32_t DMA_INT_EN;
    __I  uint32_t DMA_MFRM_BUFOF;
    __IO uint32_t DMA_REC_INT_WDT;
       uint32_t RESERVED3[8];
    __I  uint32_t DMA_CURHOST_TRANS_DES;
    __I  uint32_t DMA_CURHOST_REC_DES;
    __I  uint32_t DMA_CURHOST_TANS_BUF;
    __I  uint32_t DMA_CURHOST_REC_BUF;
    __I  uint32_t DMA_HW_FEATURE;
} LPC_EMAC_TypeDef;


/*------------- SPIFI --------------------------------------------------------*/
typedef struct
{
    __IO uint32_t Control;
    __IO uint32_t Command;
    __IO uint32_t Address;
    __IO uint32_t IntermediateData;
    __IO uint32_t AddressIntermediate;
    __IO uint32_t Data;
    __IO uint32_t MemoryCommand;
    __I  uint32_t Status;
} LPC_SPIFI_TypeDef;

/*------------- SD Host controller -----------------------------------------*/
typedef struct
{
    __IO uint32_t SDMA;             // 0x000 SDMA System Address
    __IO uint16_t BSIZE;            // 0x004 Block Size
    __IO uint16_t BCOUNT;           // 0x006 Block count
    __IO uint16_t ARG0;         // 0x008 Argument 0
    __IO uint16_t ARG1;         // 0x00A Argument 1
    __IO uint16_t TRANS;            // 0x00C Transfer mode
    __IO uint16_t CMD;          // 0x00E Command
    __IO uint16_t RESP0;            // 0x010 Response 0
    __IO uint16_t RESP1;            // 0x012 Response 1
    __IO uint16_t RESP2;            // 0x014 Response 2
    __IO uint16_t RESP3;            // 0x016 Response 3
    __IO uint16_t RESP4;            // 0x018 Response 4
    __IO uint16_t RESP5;            // 0x01A Response 5
    __IO uint16_t RESP6;            // 0x01C Response 6
    __IO uint16_t RESP7;            // 0x01E Response 7
    __IO uint16_t DATA0;            // 0x020 Dataport 0
    __IO uint16_t DATA1;            // 0x022 Dataport 1
    __IO uint32_t STATE ;           // 0x024 Present state
    __IO uint8_t  HCON;         // 0x028 Host control
    __IO uint8_t  PCON;         // 0x029 Power control
    __IO uint8_t  BGCTRL;           // 0x02A Block Gap control
    __IO uint8_t  WCTRL;            // 0x02B Wakeup control
    __IO uint16_t CLKCR;            // 0x02C Clock control register
    __IO uint8_t  TIMCTRL;      // 0x02E Timeout control
    __IO uint8_t  SRES;         // 0x02F Software reset
    __IO uint16_t INTSTAT;      // 0x030 Normal interrupt status
    __IO uint16_t ERINTSTAT;        // 0x032 Error interrupt status
    __IO uint16_t INTSTATEN;        // 0x034 Normal interrupt status enable
    __IO uint16_t ERINTSTATEN;  // 0x036 Error interrupt status enable
    __IO uint16_t INTSIGEN;     // 0x038 Normal interrupt signal enable
    __IO uint16_t ERINTSIGEN;       // 0x03A Error interrupt signal enable
    __IO uint16_t CMD12ESTAT;   // 0x03C Auto CMD12 Error Status
    __IO uint16_t RESERVED0;        // 0x03E
    __IO uint32_t CAP;          // 0x040 Capabilities
    __IO uint32_t RESERVED1;        // 0x044 Capabilities (Reserved)
    __IO uint32_t CMAXCAP;      // 0x048 Current maximum capabilities
    __IO uint32_t RESERVED2;        // 0x04C Current maximum capabilities (Reserved)
    __IO uint32_t FORCECMD12;       // 0x050 Force event for AutoCmd12 Error Status
    __IO uint8_t  ADMASTAT;     // 0x054 ADMA error status
    __IO uint8_t  RESERVED3[3]; // 0x055
    __IO uint32_t ADMA0;            // 0x058
    __IO uint32_t ADMA1;            // 0x05C
    __IO uint32_t BOOTTIM;      // 0x060 Boot data timeout control
       uint32_t RESERVED4[35];  // 0x064
    __IO uint32_t SPIINTSUP;        // 0x0F0
       uint32_t RESERVED5[2];   // 0x0F4
    __IO uint16_t SLOTINTSTAT;  // 0x0FC
    __IO uint16_t HCVERSION;        // 0x0FE
} LPC_SDIO_TypeDef;


/*------------- LCD controller (LCD) -----------------------------------------*/
typedef struct
{
    __IO uint32_t TIMH;                   /* LCD Registers   */
    __IO uint32_t TIMV;
    __IO uint32_t POL;
    __IO uint32_t LE;
    __IO uint32_t UPBASE;
    __IO uint32_t LPBASE;
    __IO uint32_t CTRL;
    __IO uint32_t INTMSK;
    __I  uint32_t INTRAW;
    __I  uint32_t INTSTAT;
    __O  uint32_t INTCLR;
    __I  uint32_t UPCURR;
    __I  uint32_t LPCURR;
       uint32_t RESERVED0[115];
    __IO uint32_t PAL[128];
       uint32_t RESERVED1[256];
    __IO uint32_t CRSR_IMG[256];
    __IO uint32_t CRSR_CTRL;
    __IO uint32_t CRSR_CFG;
    __IO uint32_t CRSR_PAL0;
    __IO uint32_t CRSR_PAL1;
    __IO uint32_t CRSR_XY;
    __IO uint32_t CRSR_CLIP;
    __IO uint32_t CRSR_INTMSK;
    __O  uint32_t CRSR_INTCLR;
    __I  uint32_t CRSR_INTRAW;
    __I  uint32_t CRSR_INTSTAT;
} LPC_LCD_TypeDef;


/***********************************************************************
* USB Register Structures
**********************************************************************/

/* USB Module Register Structure */
typedef struct
{
       uint8_t RESERVED0[0xFF];
    /*Capability registers*/
    __IO uint32_t  caplength;     /*Capability register length*/                // 100
    //  __IO uint8_t  _otg1[1];
    //  __IO uint16_t hciversion;    /*Host interface version number*/
    __IO uint32_t hcsparams;     /*Host controller structural parameters*/  // 104
    __IO uint32_t hccparams;     /*Host controller capability parameters*/  // 108
       uint32_t _otg2[5];      /*10Ch-11Fh 20 Reserved */                   // 10C 110 114 118 11C
    __IO uint32_t dciversion;    /*Device interface version number*/            // 120
    //       uint16_t _otg3[1];
    __IO uint32_t dccparams;     /*Device controller capability parameters*/    // 124
       uint32_t _otg4a[4];     /*128h-134h 16 Reserved */                   // 128 12C 130 134
    __IO uint32_t usb_up_int;    /*USB interrupt test mode*/                    // 138
       uint32_t _otg4b[1];     /*13Ch 4 Reserved */                         // 13C

    /* Operational registers */
    __IO uint32_t usbcmd;        /*USB command*/                               // 140
    __IO uint32_t usbsts;        /*USB status*/                            // 144
    __IO uint32_t usbintr;       /*USB interrupt enable*/                      // 148
    __IO uint32_t frindex;       /*USB frame index*/                           // 14C
       uint32_t _otg5[1];                                                  // 150
    __IO uint32_t periodiclistbase__deviceaddr;    /*Frame list base address__USB device address*/  //154
    __IO uint32_t asynclistaddr__endpointlistaddr; /*Next asynchronous list address__Address of endpoint list in memory*/   // 158
    __IO uint32_t ttctrl;        /*Asynchronous buffer status for embedded TT*/ // 15C
    __IO uint32_t burstsize;     /*Programmable burst size*/                        // 160
    __IO uint32_t txfilltuning;  /*Host transmit pre-buffer packet tuning*/     // 164
    __IO uint32_t txttfilltuning;/*Host TT transmit pre-buffer packet tuning*/  // 168
       uint32_t _otg6[1];                                                       // 16C
       uint32_t _otg7[2];      /*170h-174h 8 Reserved n/a*/                     // 170 174
    __IO uint32_t endptnak;                                                     // 178
    __IO uint32_t endptnaken;                                                       // 17C
    __I  uint32_t configflag;    /*Configured flag register*/                       // 180
    __IO uint32_t portsc1;       /*Port status/control 1*/                      // 184
       uint32_t _otg8[7];      /*190h-1A3h 20 Reserved n/a*/                    // 188 18C 190 194 198 19C 1A0
    __IO uint32_t otgsc;         /*OTG status and control*/                     // 1A4
    __IO uint32_t usbmode;       /*USB device mode*/                                // 1A8
    __IO uint32_t endptsetupstat;/*Endpoint setup status*/                      // 1AC
    __IO uint32_t endptprime;    /*Endpoint initialization*/                        // 1B0
    __IO uint32_t endptflush;    /*Endpoint de-initialization*/                 // 1B4
    __I  uint32_t endptstatus;   /*Endpoint status*/                                // 1B8
    __IO uint32_t endptcomplete; /*Endpoint complete*/                          // 1BC
    __IO uint32_t endptctrl[6];  /*Endpoint control 0 - 5*/                     // 1C0 1C4 1C8 1CC 1D0 1D4
} LPC_USB_TypeDef;


/*------------- External Memory Controller (EMC) -----------------------------*/
/*
typedef struct
{
    __IO uint32_t Control;
    __I  uint32_t Status;
    __IO uint32_t Config;
       uint32_t RESERVED0[5];
    __IO uint32_t DynamicControl;
    __IO uint32_t DynamicRefresh;
    __IO uint32_t DynamicReadConfig;
       uint32_t RESERVED1[1];
    __IO uint32_t DynamicRP;
    __IO uint32_t DynamicRAS;
    __IO uint32_t DynamicSREX;
    __IO uint32_t DynamicAPR;
    __IO uint32_t DynamicDAL;
    __IO uint32_t DynamicWR;
    __IO uint32_t DynamicRC;
    __IO uint32_t DynamicRFC;
    __IO uint32_t DynamicXSR;
    __IO uint32_t DynamicRRD;
    __IO uint32_t DynamicMRD;
       uint32_t RESERVED2[9];
    __IO uint32_t StaticExtendedWait;
       uint32_t RESERVED3[31];
    __IO uint32_t DynamicConfig0;
    __IO uint32_t DynamicRasCas0;
       uint32_t RESERVED4[6];
    __IO uint32_t DynamicConfig1;
    __IO uint32_t DynamicRasCas1;
       uint32_t RESERVED5[6];
    __IO uint32_t DynamicConfig2;
    __IO uint32_t DynamicRasCas2;
       uint32_t RESERVED6[6];
    __IO uint32_t DynamicConfig3;
    __IO uint32_t DynamicRasCas3;
       uint32_t RESERVED7[38];
    __IO uint32_t StaticConfig0;
    __IO uint32_t StaticWaitWen0;
    __IO uint32_t StaticWaitOen0;
    __IO uint32_t StaticWaitRd0;
    __IO uint32_t StaticWaitPage0;
    __IO uint32_t StaticWaitWr0;
    __IO uint32_t StaticWaitTurn0;
       uint32_t RESERVED8[1];
    __IO uint32_t StaticConfig1;
    __IO uint32_t StaticWaitWen1;
    __IO uint32_t StaticWaitOen1;
    __IO uint32_t StaticWaitRd1;
    __IO uint32_t StaticWaitPage1;
    __IO uint32_t StaticWaitWr1;
    __IO uint32_t StaticWaitTurn1;
       uint32_t RESERVED9[1];
    __IO uint32_t StaticConfig2;
    __IO uint32_t StaticWaitWen2;
    __IO uint32_t StaticWaitOen2;
    __IO uint32_t StaticWaitRd2;
    __IO uint32_t StaticWaitPage2;
    __IO uint32_t StaticWaitWr2;
    __IO uint32_t StaticWaitTurn2;
       uint32_t RESERVED10[1];
    __IO uint32_t StaticConfig3;
    __IO uint32_t StaticWaitWen3;
    __IO uint32_t StaticWaitOen3;
    __IO uint32_t StaticWaitRd3;
    __IO uint32_t StaticWaitPage3;
    __IO uint32_t StaticWaitWr3;
    __IO uint32_t StaticWaitTurn3;
} LPC_EMC_TypeDef;
*/
typedef struct {                            /*!< (@ 0x40005000) EMC Structure          */
  __IO uint32_t CONTROL;                    /*!< (@ 0x40005000) Controls operation of the memory controller. */
  __I  uint32_t STATUS;                     /*!< (@ 0x40005004) Provides EMC status information. */
  __IO uint32_t CONFIG;                     /*!< (@ 0x40005008) Configures operation of the memory controller. */
  __I  uint32_t RESERVED0[5];
  __IO uint32_t DYNAMICCONTROL;             /*!< (@ 0x40005020) Controls dynamic memory operation. */
  __IO uint32_t DYNAMICREFRESH;             /*!< (@ 0x40005024) Configures dynamic memory refresh operation. */
  __IO uint32_t DYNAMICREADCONFIG;          /*!< (@ 0x40005028) Configures the dynamic memory read strategy. */
  __I  uint32_t RESERVED1[1];
  __IO uint32_t DYNAMICRP;                  /*!< (@ 0x40005030) Selects the precharge command period. */
  __IO uint32_t DYNAMICRAS;                 /*!< (@ 0x40005034) Selects the active to precharge command period. */
  __IO uint32_t DYNAMICSREX;                /*!< (@ 0x40005038) Selects the self-refresh exit time. */
  __IO uint32_t DYNAMICAPR;                 /*!< (@ 0x4000503C) Selects the last-data-out to active command time. */
  __IO uint32_t DYNAMICDAL;                 /*!< (@ 0x40005040) Selects the data-in to active command time. */
  __IO uint32_t DYNAMICWR;                  /*!< (@ 0x40005044) Selects the write recovery time. */
  __IO uint32_t DYNAMICRC;                  /*!< (@ 0x40005048) Selects the active to active command period. */
  __IO uint32_t DYNAMICRFC;                 /*!< (@ 0x4000504C) Selects the auto-refresh period. */
  __IO uint32_t DYNAMICXSR;                 /*!< (@ 0x40005050) Selects the exit self-refresh to active command time. */
  __IO uint32_t DYNAMICRRD;                 /*!< (@ 0x40005054) Selects the active bank A to active bank B latency. */
  __IO uint32_t DYNAMICMRD;                 /*!< (@ 0x40005058) Selects the load mode register to active command time. */
  __I  uint32_t RESERVED2[9];
  __IO uint32_t STATICEXTENDEDWAIT;         /*!< (@ 0x40005080) Selects time for long static memory read and write transfers. */
  __I  uint32_t RESERVED3[31];
  __IO uint32_t DYNAMICCONFIG0;             /*!< (@ 0x40005100) Selects the configuration information for dynamic memory chip select n. */
  __IO uint32_t DYNAMICRASCAS0;             /*!< (@ 0x40005104) Selects the RAS and CAS latencies for dynamic memory chip select n. */
  __I  uint32_t RESERVED4[6];
  __IO uint32_t DYNAMICCONFIG1;             /*!< (@ 0x40005120) Selects the configuration information for dynamic memory chip select n. */
  __IO uint32_t DYNAMICRASCAS1;             /*!< (@ 0x40005124) Selects the RAS and CAS latencies for dynamic memory chip select n. */
  __I  uint32_t RESERVED5[6];
  __IO uint32_t DYNAMICCONFIG2;             /*!< (@ 0x40005140) Selects the configuration information for dynamic memory chip select n. */
  __IO uint32_t DYNAMICRASCAS2;             /*!< (@ 0x40005144) Selects the RAS and CAS latencies for dynamic memory chip select n. */
  __I  uint32_t RESERVED6[6];
  __IO uint32_t DYNAMICCONFIG3;             /*!< (@ 0x40005160) Selects the configuration information for dynamic memory chip select n. */
  __IO uint32_t DYNAMICRASCAS3;             /*!< (@ 0x40005164) Selects the RAS and CAS latencies for dynamic memory chip select n. */
  __I  uint32_t RESERVED7[38];
  __IO uint32_t STATICCONFIG0;              /*!< (@ 0x40005200) Selects the memory configuration for static chip select n. */
  __IO uint32_t STATICWAITWEN0;             /*!< (@ 0x40005204) Selects the delay from chip select n to write enable. */
  __IO uint32_t STATICWAITOEN0;             /*!< (@ 0x40005208) Selects the delay from chip select n or address change, whichever is later, to output enable. */
  __IO uint32_t STATICWAITRD0;              /*!< (@ 0x4000520C) Selects the delay from chip select n to a read access. */
  __IO uint32_t STATICWAITPAG0;             /*!< (@ 0x40005210) Selects the delay for asynchronous page mode sequential accesses for chip select n. */
  __IO uint32_t STATICWAITWR0;              /*!< (@ 0x40005214) Selects the delay from chip select n to a write access. */
  __I  uint32_t STATICWAITTURN0;            /*!< (@ 0x40005218) read-write             */
  __I  uint32_t RESERVED8[1];
  __IO uint32_t STATICCONFIG1;              /*!< (@ 0x40005220) Selects the memory configuration for static chip select n. */
  __IO uint32_t STATICWAITWEN1;             /*!< (@ 0x40005224) Selects the delay from chip select n to write enable. */
  __IO uint32_t STATICWAITOEN1;             /*!< (@ 0x40005228) Selects the delay from chip select n or address change, whichever is later, to output enable. */
  __IO uint32_t STATICWAITRD1;              /*!< (@ 0x4000522C) Selects the delay from chip select n to a read access. */
  __IO uint32_t STATICWAITPAG1;             /*!< (@ 0x40005230) Selects the delay for asynchronous page mode sequential accesses for chip select n. */
  __IO uint32_t STATICWAITWR1;              /*!< (@ 0x40005234) Selects the delay from chip select n to a write access. */
  __I  uint32_t STATICWAITTURN1;            /*!< (@ 0x40005238) read-write             */
  __I  uint32_t RESERVED9[1];
  __IO uint32_t STATICCONFIG2;              /*!< (@ 0x40005240) Selects the memory configuration for static chip select n. */
  __IO uint32_t STATICWAITWEN2;             /*!< (@ 0x40005244) Selects the delay from chip select n to write enable. */
  __IO uint32_t STATICWAITOEN2;             /*!< (@ 0x40005248) Selects the delay from chip select n or address change, whichever is later, to output enable. */
  __IO uint32_t STATICWAITRD2;              /*!< (@ 0x4000524C) Selects the delay from chip select n to a read access. */
  __IO uint32_t STATICWAITPAG2;             /*!< (@ 0x40005250) Selects the delay for asynchronous page mode sequential accesses for chip select n. */
  __IO uint32_t STATICWAITWR2;              /*!< (@ 0x40005254) Selects the delay from chip select n to a write access. */
  __I  uint32_t STATICWAITTURN2;            /*!< (@ 0x40005258) read-write             */
  __I  uint32_t RESERVED10[1];
  __IO uint32_t STATICCONFIG3;              /*!< (@ 0x40005260) Selects the memory configuration for static chip select n. */
  __IO uint32_t STATICWAITWEN3;             /*!< (@ 0x40005264) Selects the delay from chip select n to write enable. */
  __IO uint32_t STATICWAITOEN3;             /*!< (@ 0x40005268) Selects the delay from chip select n or address change, whichever is later, to output enable. */
  __IO uint32_t STATICWAITRD3;              /*!< (@ 0x4000526C) Selects the delay from chip select n to a read access. */
  __IO uint32_t STATICWAITPAG3;             /*!< (@ 0x40005270) Selects the delay for asynchronous page mode sequential accesses for chip select n. */
  __IO uint32_t STATICWAITWR3;              /*!< (@ 0x40005274) Selects the delay from chip select n to a write access. */
  __I  uint32_t STATICWAITTURN3;            /*!< (@ 0x40005278) read-write             */
} LPC_EMC_TypeDef;


/*------------- Regfile RTC memory --------------------------------------*/
typedef struct
{
    __IO uint32_t REG[64];
}LPC_REGFILE_TypeDef;


/*------------- Reset Generation Unit (RGU) -----------------------------*/
typedef struct
{
       uint32_t RESERVED0[64];          /* 0x0000 */
    __O  uint32_t RESET_CTRL0;          /* 0x0100 */
    __O  uint32_t RESET_CTRL1;          /* 0x0104 */
       uint32_t RESERVED1[2];           /* 0x0108 */
    __IO uint32_t RESET_STATUS0;            /* 0x0110 */
    __IO uint32_t RESET_STATUS1;            /* 0x0114 */
    __IO uint32_t RESET_STATUS2;            /* 0x0118 */
    __IO uint32_t RESET_STATUS3;            /* 0x011C */
       uint32_t RESERVED2[12];          /* 0x0120 */
    __I  uint32_t RESET_ACTIVE_STATUS0; /* 0x0150 */
    __I  uint32_t RESET_ACTIVE_STATUS1; /* 0x0154 */
} LPC_RGU_TypeDef;


/*------------------------ Serial GPIO (SGPIO) --------------------------*/
typedef struct
{
    __IO  uint16_t COUNT;
        uint16_t RESERVED0;
    __IO  uint16_t PRESET;
        uint16_t RESERVED1;
    __IO    uint32_t REG;
    __IO    uint32_t REG_SS;
    __IO    uint32_t REGOE;
    __IO    uint32_t REGOE_SS;
    __IO    uint8_t  POS;
        uint8_t  RESERVED2;
        uint16_t RESERVED3;
        uint32_t RESERVED4[9];
} LPC_SGPIO_COUNTER_TypeDef;

typedef struct
{
    __IO    uint32_t                    CTRL_ENABLE;        /* 0x0000 */
        uint32_t                    RESERVED0[15];      /* 0x0004 */
    __IO    LPC_SGPIO_COUNTER_TypeDef   COUNTER[16];        /* 0x0040 */
        uint32_t                    RESERVED1[742];     /* 0x0440 */
    __O   uint32_t                  CLR_ENABLE;         /* 0x0FD8 */
    __O   uint32_t                  SET_ENABLE;         /* 0x0FDC */
    __I     uint32_t                    FLAG_COUNT_POS;     /* 0x0FE0 */
    __I     uint32_t                    EN_COUNT_POS;       /* 0x0FE4 */
    __O   uint16_t                  CLR_STATUS;         /* 0x0FE8 */
        uint16_t                    RESERVED2;          /* 0x0FEA */
    __O uint16_t                    SET_STATUS;         /* 0x0FEC */
        uint16_t                    RESERVED3;          /* 0x0FEE */
} LPC_SGPIO_TypeDef;

/*------------- State Configurable Timer (SCT) -----------*/

#define CONFIG_SCT_nEV   (16)            /* Number of events */
#define CONFIG_SCT_nRG   (16)            /* Number of match/compare registers */
#define CONFIG_SCT_nOU   (16)            /* Number of outputs */


typedef struct
{
    __IO  uint32_t CONFIG;              /* 0x000 Configuration Register */
    union {
        __IO uint32_t CTRL_U;           /* 0x004 Control Register */
        struct {
            __IO uint16_t CTRL_L;       /* 0x004 low control register */
            __IO uint16_t CTRL_H;       /* 0x006 high control register */
        };
    };
    __IO uint16_t LIMIT_L;              /* 0x008 limit register for counter L */
    __IO uint16_t LIMIT_H;              /* 0x00A limit register for counter H */
    __IO uint16_t HALT_L;               /* 0x00C halt register for counter L */
    __IO uint16_t HALT_H;               /* 0x00E halt register for counter H */
    __IO uint16_t STOP_L;               /* 0x010 stop register for counter L */
    __IO uint16_t STOP_H;               /* 0x012 stop register for counter H */
    __IO uint16_t START_L;              /* 0x014 start register for counter L */
    __IO uint16_t START_H;              /* 0x016 start register for counter H */
         uint32_t RESERVED1[10];        /* 0x018-0x03C reserved */
    union {
        __IO uint32_t COUNT_U;          /* 0x040 counter register */
        struct {
            __IO uint16_t COUNT_L;      /* 0x040 counter register for counter L */
            __IO uint16_t COUNT_H;      /* 0x042 counter register for counter H */
        };
    };
    __IO uint16_t STATE_L;              /* 0x044 state register for counter L */
    __IO uint16_t STATE_H;              /* 0x046 state register for counter H */
    __I  uint32_t INPUT;                /* 0x048 input register */
    __IO uint16_t REGMODE_L;            /* 0x04C match - capture registers mode register L */
    __IO uint16_t REGMODE_H;            /* 0x04E match - capture registers mode register H */
    __IO uint32_t OUTPUT;               /* 0x050 output register */
    __IO uint32_t BIDIRCTRL;            /* 0x054 Bidirectional Control Register */
    __IO uint32_t RES;                  /* 0x058 conflict resolution register */
    __IO uint32_t DMA0REQUEST;          /* 0x05C DMA0 Request Register */
    __IO uint32_t DMA1REQUEST;          /* 0x060 DMA1 Request Register */
         uint32_t RESERVED2[35];        /* 0x064-0x0EC reserved */
    __IO uint32_t EVEN;                 /* 0x0F0 event enable register */
    __IO uint32_t EVFLAG;               /* 0x0F4 event flag register */
    __IO uint32_t CONEN;                /* 0x0F8 conflict enable register */
    __IO uint32_t CONFLAG;              /* 0x0FC conflict flag register */

    union {
        __IO union {                    /* 0x100-... Match / Capture value */
            uint32_t U;                 /*       SCTMATCH[i].U  Unified 32-bit register */
            struct {
                uint16_t L;             /*       SCTMATCH[i].L  Access to L value */
                uint16_t H;             /*       SCTMATCH[i].H  Access to H value */
            };
        } MATCH[CONFIG_SCT_nRG];
        __I union {
            uint32_t U;                 /*       SCTCAP[i].U  Unified 32-bit register */
            struct {
                uint16_t L;             /*       SCTCAP[i].L  Access to H value */
                uint16_t H;             /*       SCTCAP[i].H  Access to H value */
            };
        } CAP[CONFIG_SCT_nRG];
    };

         uint32_t RESERVED3[32-CONFIG_SCT_nRG];      /* ...-0x17C reserved */

    union {
        __IO uint16_t MATCH_L[CONFIG_SCT_nRG];       /* 0x180-... Match Value L counter */
        __I  uint16_t CAP_L[CONFIG_SCT_nRG];         /* 0x180-... Capture Value L counter */
    };
         uint16_t RESERVED4[32-CONFIG_SCT_nRG];      /* ...-0x1BE reserved */
    union {
        __IO uint16_t MATCH_H[CONFIG_SCT_nRG];       /* 0x1C0-... Match Value H counter */
        __I  uint16_t CAP_H[CONFIG_SCT_nRG];         /* 0x1C0-... Capture Value H counter */
    };
         uint16_t RESERVED5[32-CONFIG_SCT_nRG];      /* ...-0x1FE reserved */

    union {
        __IO union {                    /* 0x200-... Match Reload / Capture Control value */
            uint32_t U;                 /*       SCTMATCHREL[i].U  Unified 32-bit register */
            struct {
                uint16_t L;             /*       SCTMATCHREL[i].L  Access to L value */
                uint16_t H;             /*       SCTMATCHREL[i].H  Access to H value */
            };
        } MATCHREL[CONFIG_SCT_nRG];
        __IO union {
            uint32_t U;                 /*       SCTCAPCTRL[i].U  Unified 32-bit register */
            struct {
                uint16_t L;             /*       SCTCAPCTRL[i].L  Access to H value */
                uint16_t H;             /*       SCTCAPCTRL[i].H  Access to H value */
            };
        } CAPCTRL[CONFIG_SCT_nRG];
    };

         uint32_t RESERVED6[32-CONFIG_SCT_nRG];      /* ...-0x27C reserved */

    union {
        __IO uint16_t MATCHREL_L[CONFIG_SCT_nRG];    /* 0x280-... Match Reload value L counter */
        __IO uint16_t CAPCTRL_L[CONFIG_SCT_nRG];     /* 0x280-... Capture Control value L counter */
    };
         uint16_t RESERVED7[32-CONFIG_SCT_nRG];      /* ...-0x2BE reserved */
    union {
        __IO uint16_t MATCHREL_H[CONFIG_SCT_nRG];    /* 0x2C0-... Match Reload value H counter */
        __IO uint16_t CAPCTRL_H[CONFIG_SCT_nRG];     /* 0x2C0-... Capture Control value H counter */
    };
         uint16_t RESERVED8[32-CONFIG_SCT_nRG];      /* ...-0x2FE reserved */

    __IO struct {                       /* 0x300-0x3FC  SCTEVENT[i].STATE / SCTEVENT[i].CTRL*/
        uint32_t STATE;                 /* Event State Register */
        uint32_t CTRL;                  /* Event Control Register */
    } EVENT[CONFIG_SCT_nEV];

         uint32_t RESERVED9[128-2*CONFIG_SCT_nEV];   /* ...-0x4FC reserved */

    __IO struct {                       /* 0x500-0x57C  SCTOUT[i].SET / SCTOUT[i].CLR */
        uint32_t SET;                   /* Output n Set Register */
        uint32_t CLR;                   /* Output n Clear Register */
    } OUT[CONFIG_SCT_nOU];

         uint32_t RESERVED10[191-2*CONFIG_SCT_nOU];  /* ...-0x7F8 reserved */

    __I  uint32_t MODULECONTENT;        /* 0x7FC Module Content */

} LPC_SCT_TypeDef;


/*------------- IP_2113 Embedded Flash controller ----------------------------*/
typedef struct
{
    __IO uint32_t FCTR;                 /* Flash control register                       */
    __I  uint32_t FSTAT;                    /* Flash status register                        */
    __IO uint32_t FPTR;                 /* Flash program time register                  */
    __IO uint32_t FTCTR1;                   /* FLASH test control 1 register                */
    __IO uint32_t FBWST;                    /* FLASH bridge wait state register             */
     uint32_t RESERVED0[1];
    __IO uint32_t FTCTR2;                   /* FLASH test control 2 register                */
    __IO uint32_t FCRA;                 /* FLASH clock divider for 66kHz generation     */
    __IO uint32_t FMSSTART;             /* FLASH MIST start address                     */
    __IO uint32_t FMSSTOP;              /* FLASH MISR stop address                      */
    __I  uint32_t FMS16;                    /* FLASH 16 bit signature register              */
    __I  uint32_t FMSW0;                    /* FLASH 128 bit signature, word 0              */
    __I  uint32_t FMSW1;                    /* FLASH 128 bit signature, word 1              */
    __I  uint32_t FMSW2;                    /* FLASH 128 bit signature, word 2              */
    __I  uint32_t FMSW3;                    /* FLASH 128 bit signature, word 3              */
     uint32_t RESERVED1[1];
    __I  uint32_t POS_DCM_CNT;          /* FLASH positive DCM counter                   */
    __I  uint32_t NEG_DCM_CNT;          /* FLASH negative DCM counter                   */
    __O  uint32_t START_DCM;                /* FLASH start DCM bit                          */
     uint32_t RESERVED2[1];
    __IO uint32_t ERR_SECTOR_I;         /* Error corrected in index sector              */
    __IO uint32_t ERR_SECTOR_A;         /* Error corrected in sector [0 .. 31]          */
    __IO uint32_t ERR_SECTOR_B;         /* Error corrected in sector [32 .. 63]         */
    __IO uint32_t ERR_SECTOR_C;         /* Error corrected in sector [64 .. 95]         */
    __IO uint32_t ERR_SECTOR_D;         /* Error corrected in sector [96 .. 127]        */
    __IO uint32_t ERR_SECTOR_E;         /* Error corrected in sector [128 .. 159]       */
     uint32_t RESERVED3[2];
    __O  uint32_t FBADDR;                   /* FLASH address for writes                     */
     uint32_t RESERVED4[3];
    __O  uint32_t FBWDATAW0;                /* FLASH write data word 0                      */
    __O  uint32_t FBWDATAW1;                /* FLASH write data word 1                      */
    __O  uint32_t FBWDATAW2;                /* FLASH write data word 2                      */
    __O  uint32_t FBWDATAW3;                /* FLASH write data word 3                      */
    __O  uint32_t FBWDATAW4;                /* FLASH write data word 4                      */
    __O  uint32_t FBWDATAW5;                /* FLASH write data word 5                      */
    __O  uint32_t FBWDATAW6;                /* FLASH write data word 6                      */
    __O  uint32_t FBWDATAW7;                /* FLASH write data word 7                      */
     uint32_t RESERVED5[972];
    __I  uint32_t HDK_CONFIG;               /* HDK configuration register                   */
     uint32_t RESERVED6[1];
    __O  uint32_t INT_CLR_ENABLE;           /* Clear interrupt enable bits                  */
    __O  uint32_t INT_SET_ENABLE;           /* Set interrupt enable bits                    */
    __I  uint32_t INT_STATUS;               /* Interrupt status bits                        */
    __I  uint32_t INT_ENABLE;               /* Interrupt enable bits                        */
    __O  uint32_t INT_CLR_STATUS;           /* Clear interrupt status bits                  */
    __O  uint32_t INT_SET_STATUS;           /* Set interrupt status bits                    */
    __IO uint32_t SW_RESET_CFG;         /* Software Reset Register                      */
     uint32_t RESERVED7[2];
    __I  uint32_t MODULE_ID;                /* Embedded FLASH/EEPROM module identification  */
 } LPC_FMC_TypeDef;



/******************************************************************************/
/*                         Peripheral memory map                              */
/******************************************************************************/

#define LPC_ADC0_BASE       0x400E3000
#define LPC_ADC1_BASE       0x400E4000
#define LPC_ATIMER_BASE     0x40040000
#define LPC_C_CAN_BASE      0x400E2000
#define LPC_CCU1_BASE       0x40051000
#define LPC_CCU2_BASE       0x40052000
#define LPC_CGU_BASE        0x40050000
#define LPC_CREG_BASE       0x40043000
#define LPC_DAC_BASE        0x400E1000
#define LPC_EMAC_BASE       0x40010000
#define LPC_GPDMA_BASE      0x40002000
#define LPC_GPDMACH_BASE(c) (0x40002100 + ((c) * 0x20))
#define LPC_GPDMACH0_BASE   0x40002100
#define LPC_GPDMACH1_BASE   0x40002120
#define LPC_GPDMACH2_BASE   0x40002140
#define LPC_GPDMACH3_BASE   0x40002160
#define LPC_GPDMACH4_BASE   0x40002180
#define LPC_GPDMACH5_BASE   0x400021A0
#define LPC_GPDMACH6_BASE   0x400021C0
#define LPC_GPDMACH7_BASE   0x400021E0
#define LPC_EMC_BASE        0x40005000
#define LPC_GPIO_BASE       0x400F0000
#define LPC_I2C0_BASE       0x400A1000
#define LPC_I2C1_BASE       0x400E0000
#define LPC_I2S_BASE        0x400A2000
#define LPC_LCD_BASE        0x40008000
#define LPC_M0_RAM_BASE     0x18000000
#define LPC_M0_ROM_BASE     0x18400000
#define LPC_MCPWM_BASE      0x400A0000
#define LPC_RIT_BASE        0x400C0000
#define LPC_OTP_CTRL_BASE   0x40045000
#define LPC_PMC_BASE        0x40042000
#define LPC_QEI_BASE        0x400C6000
#define LPC_REGFILE_BASE    0x40041000
#define LPC_RGU_BASE        0x40053000
#define LPC_RTC_BASE        0x40046000
#define LPC_SCU_BASE        0x40086000
#define LPC_SDIO_BASE       0x40004000
#define LPC_SGPIO_BASE      0x40101000
#define LPC_SPI_BASE        0x40100000
#define LPC_SPIFI_DATA_BASE 0x80000000
#define LPC_SPIFI_BASE      0x40003000
#define LPC_SSP0_BASE       0x40083000
#define LPC_SSP1_BASE       0x400C5000
#define LPC_TIMER0_BASE             (0x40084000)
#define LPC_TIMER1_BASE             (0x40085000)
#define LPC_TIMER2_BASE             (0x400C3000)
#define LPC_TIMER3_BASE             (0x400C4000)
#define LPC_UART0_BASE      0x40081000
#define LPC_UART1_BASE      0x40082000
#define LPC_UART2_BASE      0x400C1000
#define LPC_UART3_BASE      0x400C2000
#define LPC_USB0_BASE       0x40006000
#define LPC_USB1_BASE       0x40007000
#define LPC_SCT_BASE        0x40000000
#define LPC_WIC_BASE        0x40044000
#define LPC_WWDT_BASE       0x40080000
#define LPC_FMC0_BASE       0x4000A000
#define LPC_FMC1_BASE       0x4000B000
#define LPC_FLASH0_BASE     0x1A000000
#define LPC_FLASH1_BASE     0x1B000000

#if defined ( __CC_ARM   )
#pragma no_anon_unions
#endif

/******************************************************************************/
/*                         Peripheral declaration                             */
/******************************************************************************/
#define LPC_CGU               ((LPC_CGU_TypeDef       *) LPC_CGU_BASE      )
#define LPC_CCU1              ((LPC_CCU1_TypeDef      *) LPC_CCU1_BASE     )
#define LPC_CCU2              ((LPC_CCU2_TypeDef      *) LPC_CCU2_BASE     )
#define LPC_SCU_PIN(po, pi)   (*(volatile int         *) (LPC_SCU_BASE + ((po) * 0x80) + ((pi) * 0x4)))
#define LPC_SCU_CLK(c)        (*(volatile int         *) (LPC_SCU_BASE + 0xC00 + ((c) * 0x4)))
#define LPC_SCU               ((LPC_SCU_TypeDef       *) LPC_SCU_BASE      )
#define LPC_CREG              ((LPC_CREG_TypeDef      *) LPC_CREG_BASE     )
#define LPC_PMC               ((LPC_PMC_TypeDef       *) LPC_PMC_BASE      )
#define LPC_ATIMER            ((LPC_ATIMER_TypeDef    *) LPC_ATIMER_BASE   )
#define LPC_WIC               ((LPC_WIC_TypeDef       *) LPC_WIC_BASE      )
#define LPC_GPIO0             ((LPC_GPIO_TypeDef      *) (LPC_GPIO_BASE+0x00))
#define LPC_GPIO1             ((LPC_GPIO_TypeDef      *) (LPC_GPIO_BASE+0x20))
#define LPC_GPIO2             ((LPC_GPIO_TypeDef      *) (LPC_GPIO_BASE+0x40))
#define LPC_GPIO3             ((LPC_GPIO_TypeDef      *) (LPC_GPIO_BASE+0x60))
#define LPC_GPIO4             ((LPC_GPIO_TypeDef      *) (LPC_GPIO_BASE+0x80))
#define LPC_WDT               ((LPC_WDT_TypeDef       *) LPC_WWDT_BASE     )
#define LPC_TIMER0            ((LPC_TIMERn_Type       *) LPC_TIMER0_BASE)
#define LPC_TIMER1            ((LPC_TIMERn_Type       *) LPC_TIMER1_BASE)
#define LPC_TIMER2            ((LPC_TIMERn_Type       *) LPC_TIMER2_BASE)
#define LPC_TIMER3            ((LPC_TIMERn_Type       *) LPC_TIMER3_BASE)
#define LPC_RIT               ((LPC_RIT_TypeDef       *) LPC_RIT_BASE      )
#define LPC_UART023(u)        ((LPC_UART0_2_3_TypeDef *) ((((u) == 0) ? LPC_UART0_BASE : LPC_UART2_BASE + (((u) - 2) * 0x1000))))
#define LPC_UART0             ((LPC_UART0_2_3_TypeDef *) LPC_UART0_BASE    )
#define LPC_UART1             ((LPC_UART1_TypeDef     *) LPC_UART1_BASE    )
#define LPC_UART2             ((LPC_UART0_2_3_TypeDef *) LPC_UART2_BASE    )
#define LPC_UART3             ((LPC_UART0_2_3_TypeDef *) LPC_UART3_BASE    )
#define LPC_PWM1              ((LPC_PWM_TypeDef       *) LPC_PWM1_BASE     )
#define LPC_I2C0              ((LPC_I2C_TypeDef       *) LPC_I2C0_BASE     )
#define LPC_I2C1              ((LPC_I2C_TypeDef       *) LPC_I2C1_BASE     )
#define LPC_I2C2              ((LPC_I2C_TypeDef       *) LPC_I2C2_BASE     )
#define LPC_I2S               ((LPC_I2S_TypeDef       *) LPC_I2S_BASE      )
#define LPC_SPI               ((LPC_SPI_TypeDef       *) LPC_SPI_BASE      )
#define LPC_RTC               ((LPC_RTC_TypeDef       *) LPC_RTC_BASE      )
#define LPC_GPIOINT           ((LPC_GPIOINT_TypeDef   *) LPC_GPIOINT_BASE  )
#define LPC_PINCON            ((LPC_PINCON_TypeDef    *) LPC_PINCON_BASE   )
#define LPC_SSP0              ((LPC_SSP_TypeDef       *) LPC_SSP0_BASE     )
#define LPC_SSP1              ((LPC_SSP_TypeDef       *) LPC_SSP1_BASE     )
#define LPC_ADC0              ((LPC_ADC_TypeDef       *) LPC_ADC0_BASE     )
#define LPC_ADC1              ((LPC_ADC_TypeDef       *) LPC_ADC1_BASE     )
#define LPC_DAC               ((LPC_DAC_TypeDef       *) LPC_DAC_BASE      )
#define LPC_C_CAN             ((LPC_CCAN_TypeDef      *) LPC_C_CAN_BASE    )
#define LPC_MCPWM             ((LPC_MCPWM_TypeDef     *) LPC_MCPWM_BASE    )
#define LPC_QEI               ((LPC_QEI_TypeDef       *) LPC_QEI_BASE      )
#define LPC_EMAC              ((LPC_EMAC_TypeDef      *) LPC_EMAC_BASE     )
#define LPC_GPDMA             ((LPC_GPDMA_TypeDef     *) LPC_GPDMA_BASE    )
#define LPC_GPDMACH(c)        ((LPC_GPDMACH_TypeDef   *) LPC_GPDMACH_BASE(c))
#define LPC_GPDMACH0          ((LPC_GPDMACH_TypeDef   *) LPC_GPDMACH0_BASE )
#define LPC_GPDMACH1          ((LPC_GPDMACH_TypeDef   *) LPC_GPDMACH1_BASE )
#define LPC_GPDMACH2          ((LPC_GPDMACH_TypeDef   *) LPC_GPDMACH2_BASE )
#define LPC_GPDMACH3          ((LPC_GPDMACH_TypeDef   *) LPC_GPDMACH3_BASE )
#define LPC_GPDMACH4          ((LPC_GPDMACH_TypeDef   *) LPC_GPDMACH4_BASE )
#define LPC_GPDMACH5          ((LPC_GPDMACH_TypeDef   *) LPC_GPDMACH5_BASE )
#define LPC_GPDMACH6          ((LPC_GPDMACH_TypeDef   *) LPC_GPDMACH6_BASE )
#define LPC_GPDMACH7          ((LPC_GPDMACH_TypeDef   *) LPC_GPDMACH7_BASE )
#define LPC_USB0              ((LPC_USB_TypeDef       *) LPC_USB0_BASE     )
#define LPC_USB1              ((LPC_USB_TypeDef       *) LPC_USB1_BASE     )
#define LPC_SPIFI             ((LPC_SPIFI_TypeDef     *) LPC_SPIFI_BASE    )
#define LPC_SDIO              ((LPC_SDIO_TypeDef      *) LPC_SDIO_BASE     )
#define LPC_LCD               ((LPC_LCD_TypeDef       *) LPC_LCD_BASE      )
#define LPC_EMC               ((LPC_EMC_TypeDef       *) LPC_EMC_BASE      )
#define LPC_REG               ((LPC_REGFILE_TypeDef   *) LPC_REGFILE_BASE  )
#define LPC_RGU               ((LPC_RGU_TypeDef       *) LPC_RGU_BASE      )
#define LPC_SGPIO             ((LPC_SGPIO_TypeDef     *) LPC_SGPIO_BASE    )
#define LPC_SCT               ((LPC_SCT_TypeDef       *) LPC_SCT_BASE      )
#define FB0                   ((LPC_FMC_TypeDef       *) LPC_FMC0_BASE     )
#define FB1                   ((LPC_FMC_TypeDef       *) LPC_FMC1_BASE     )

#endif  // __LPC43xx_TC2_H__
